/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.ContinuedFraction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J,\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J,\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/Gamma;", "", "()V", "C_LIMIT", "", "DEFAULT_EPSILON", "GAMMA", "getGAMMA", "()D", "HALF_LOG_2_PI", "LANCZOS", "", "S_LIMIT", "digamma", "x", "logGamma", "regularizedGammaP", "a", "epsilon", "maxIterations", "", "regularizedGammaQ", "trigamma", "plot-base"})
public final class Gamma {
    @NotNull
    public static final Gamma INSTANCE = new Gamma();
    private static final double GAMMA = 0.5772156649015329;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    @NotNull
    private static final double[] LANCZOS;
    private static final double HALF_LOG_2_PI;
    private static final double C_LIMIT;
    private static final double S_LIMIT;

    private Gamma() {
    }

    public final double getGAMMA() {
        return GAMMA;
    }

    public final double logGamma(double x) {
        double ret = 0.0;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double g = 4.7421875;
            double sum = 0.0;
            for (int i = LANCZOS.length - 1; 0 < i; --i) {
                sum += LANCZOS[i] / (x + (double)i);
            }
            double tmp = x + g + 0.5;
            ret = (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log((sum += LANCZOS[0]) / x);
        }
        return ret;
    }

    @JvmOverloads
    public final double regularizedGammaP(double a2, double x, double epsilon, int maxIterations) {
        double ret = 0.0;
        if (Double.isNaN(a2) || Double.isNaN(x) || a2 <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else if (x >= a2 + 1.0) {
            ret = 1.0 - this.regularizedGammaQ(a2, x, epsilon, maxIterations);
        } else {
            double sum;
            double an;
            double n = 0.0;
            for (sum = an = 1.0 / a2; Math.abs(an / sum) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a2 + (n += 1.0)))) {
            }
            if (n >= (double)maxIterations) {
                throw new IllegalStateException(("MaxCountExceeded - maxIterations: " + maxIterations).toString());
            }
            ret = Double.isInfinite(sum) ? 1.0 : Math.exp(-x + a2 * Math.log(x) - this.logGamma(a2)) * sum;
        }
        return ret;
    }

    public static /* synthetic */ double regularizedGammaP$default(Gamma gamma2, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d3 = DEFAULT_EPSILON;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return gamma2.regularizedGammaP(d, d2, d3, n);
    }

    @JvmOverloads
    public final double regularizedGammaQ(double a2, double x, double epsilon, int maxIterations) {
        double ret = 0.0;
        if (Double.isNaN(a2) || Double.isNaN(x) || a2 <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 1.0;
        } else if (x < a2 + 1.0) {
            ret = 1.0 - this.regularizedGammaP(a2, x, epsilon, maxIterations);
        } else {
            ContinuedFraction cf2 = new ContinuedFraction(a2){
                final /* synthetic */ double $a;
                {
                    this.$a = $a;
                }

                protected double getA(int n, double x) {
                    return 2.0 * (double)n + 1.0 - this.$a + x;
                }

                protected double getB(int n, double x) {
                    return (double)n * (this.$a - (double)n);
                }
            };
            ret = 1.0 / cf2.evaluate(x, epsilon, maxIterations);
            ret = Math.exp(-x + a2 * Math.log(x) - this.logGamma(a2)) * ret;
        }
        return ret;
    }

    public static /* synthetic */ double regularizedGammaQ$default(Gamma gamma2, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d3 = DEFAULT_EPSILON;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return gamma2.regularizedGammaQ(d, d2, d3, n);
    }

    public final double digamma(double x) {
        if (x > 0.0 && x <= S_LIMIT) {
            return -GAMMA - 1.0 / x;
        }
        if (x >= C_LIMIT) {
            double inv = 1.0 / (x * x);
            return Math.log(x) - 0.5 / x - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / (double)252));
        }
        return this.digamma(x + 1.0) - 1.0 / x;
    }

    public final double trigamma(double x) {
        if (x > 0.0 && x <= S_LIMIT) {
            return 1.0 / (x * x);
        }
        if (x >= C_LIMIT) {
            double inv = 1.0 / (x * x);
            return 1.0 / x + inv / (double)2 + inv / x * (0.16666666666666666 - inv * (0.03333333333333333 + inv / (double)42));
        }
        return this.trigamma(x + 1.0) + 1.0 / (x * x);
    }

    @JvmOverloads
    public final double regularizedGammaP(double a2, double x, double epsilon) {
        return Gamma.regularizedGammaP$default(this, a2, x, epsilon, 0, 8, null);
    }

    @JvmOverloads
    public final double regularizedGammaP(double a2, double x) {
        return Gamma.regularizedGammaP$default(this, a2, x, 0.0, 0, 12, null);
    }

    @JvmOverloads
    public final double regularizedGammaQ(double a2, double x, double epsilon) {
        return Gamma.regularizedGammaQ$default(this, a2, x, epsilon, 0, 8, null);
    }

    @JvmOverloads
    public final double regularizedGammaQ(double a2, double x) {
        return Gamma.regularizedGammaQ$default(this, a2, x, 0.0, 0, 12, null);
    }

    static {
        double[] dArray = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        LANCZOS = dArray;
        HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);
        C_LIMIT = 49.0;
        S_LIMIT = 1.0E-5;
    }
}

