/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class AtomicArray
implements AtomicSequence {
    private static final List<AtomicValue> emptyAtomicList = Collections.emptyList();
    public static AtomicArray EMPTY_ATOMIC_ARRAY = new AtomicArray(emptyAtomicList);
    private final List<AtomicValue> content;

    public AtomicArray(List<AtomicValue> content) {
        this.content = content;
    }

    public AtomicArray(SequenceIterator iter) throws XPathException {
        ArrayList<AtomicValue> list = new ArrayList<AtomicValue>(10);
        SequenceTool.supply(iter, item -> list.add((AtomicValue)item));
        this.content = list;
    }

    @Override
    public AtomicValue head() {
        return this.content.isEmpty() ? null : this.content.get(0);
    }

    @Override
    public AtomicIterator iterate() {
        return new ListIterator.OfAtomic<AtomicValue>(this.content);
    }

    @Override
    public AtomicValue itemAt(int n) {
        if (n >= 0 && n < this.content.size()) {
            return this.content.get(n);
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.content.size();
    }

    @Override
    public AtomicArray subsequence(int start, int length) {
        if (start < 0) {
            start = 0;
        }
        if (start + length > this.content.size()) {
            length = this.content.size() - start;
        }
        return new AtomicArray(this.content.subList(start, start + length));
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        return this.getUnicodeStringValue();
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        UnicodeBuilder ub = new UnicodeBuilder();
        boolean first = true;
        for (AtomicValue av : this.content) {
            if (!first) {
                ub.append(' ');
            } else {
                first = false;
            }
            ub.accept(av.getUnicodeStringValue());
        }
        return ub.toUnicodeString();
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder(64);
        boolean first = true;
        for (AtomicValue av : this.content) {
            if (!first) {
                sb.append(' ');
            } else {
                first = false;
            }
            sb.append(av.getStringValue());
        }
        return sb.toString();
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return this.content.iterator();
    }
}

