/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.algorithm.PolygonNodeTopology;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.operation.relateng.NodeSection;
import org.locationtech.jts.operation.relateng.NodeSections;
import org.locationtech.jts.operation.relateng.RelateEdge;
import org.locationtech.jts.operation.relateng.RelateGeometry;
import org.locationtech.jts.operation.relateng.RelateNode;
import org.locationtech.jts.operation.relateng.TopologyPredicate;

class TopologyComputer {
    private static final String MSG_GEOMETRY_DIMENSION_UNEXPECTED = "Unexpected combination of geometry dimensions";
    private TopologyPredicate predicate;
    private RelateGeometry geomA;
    private RelateGeometry geomB;
    private Map<Coordinate, NodeSections> nodeMap = new HashMap<Coordinate, NodeSections>();

    public TopologyComputer(TopologyPredicate predicate, RelateGeometry geomA, RelateGeometry geomB) {
        this.predicate = predicate;
        this.geomA = geomA;
        this.geomB = geomB;
        this.initExteriorDims();
    }

    private void initExteriorDims() {
        int dimRealA = this.geomA.getDimensionReal();
        int dimRealB = this.geomB.getDimensionReal();
        if (dimRealA == 0 && dimRealB == 1) {
            this.updateDim(2, 0, 1);
        } else if (dimRealA == 1 && dimRealB == 0) {
            this.updateDim(0, 2, 1);
        } else if (dimRealA == 0 && dimRealB == 2) {
            this.updateDim(2, 0, 2);
            this.updateDim(2, 1, 1);
        } else if (dimRealA == 2 && dimRealB == 0) {
            this.updateDim(0, 2, 2);
            this.updateDim(1, 2, 1);
        } else if (dimRealA == 1 && dimRealB == 2) {
            this.updateDim(2, 0, 2);
        } else if (dimRealA == 2 && dimRealB == 1) {
            this.updateDim(0, 2, 2);
        } else if (dimRealA == -1 || dimRealB == -1) {
            if (dimRealA != -1) {
                this.initExteriorEmpty(true);
            }
            if (dimRealB != -1) {
                this.initExteriorEmpty(false);
            }
        }
    }

    private void initExteriorEmpty(boolean geomNonEmpty) {
        int dimNonEmpty = this.getDimension(geomNonEmpty);
        switch (dimNonEmpty) {
            case 0: {
                this.updateDim(geomNonEmpty, 0, 2, 0);
                break;
            }
            case 1: {
                if (this.getGeometry(geomNonEmpty).hasBoundary()) {
                    this.updateDim(geomNonEmpty, 1, 2, 0);
                }
                this.updateDim(geomNonEmpty, 0, 2, 1);
                break;
            }
            case 2: {
                this.updateDim(geomNonEmpty, 1, 2, 1);
                this.updateDim(geomNonEmpty, 0, 2, 2);
            }
        }
    }

    private RelateGeometry getGeometry(boolean isA) {
        return isA ? this.geomA : this.geomB;
    }

    public int getDimension(boolean isA) {
        return this.getGeometry(isA).getDimension();
    }

    public boolean isAreaArea() {
        return this.getDimension(true) == 2 && this.getDimension(false) == 2;
    }

    public boolean isSelfNodingRequired() {
        return this.predicate.requireSelfNoding() && (this.geomA.isSelfNodingRequired() || this.geomB.isSelfNodingRequired());
    }

    public boolean isExteriorCheckRequired(boolean isA) {
        return this.predicate.requireExteriorCheck(isA);
    }

    private void updateDim(int locA, int locB, int dimension) {
        this.predicate.updateDimension(locA, locB, dimension);
    }

    private void updateDim(boolean isAB, int loc1, int loc2, int dimension) {
        if (isAB) {
            this.updateDim(loc1, loc2, dimension);
        } else {
            this.updateDim(loc2, loc1, dimension);
        }
    }

    public boolean isResultKnown() {
        return this.predicate.isKnown();
    }

    public boolean getResult() {
        return this.predicate.value();
    }

    public void finish() {
        this.predicate.finish();
    }

    private NodeSections getNodeSections(Coordinate nodePt) {
        NodeSections node = this.nodeMap.get(nodePt);
        if (node == null) {
            node = new NodeSections(nodePt);
            this.nodeMap.put(nodePt, node);
        }
        return node;
    }

    public void addIntersection(NodeSection a, NodeSection b) {
        if (!a.isSameGeometry(b)) {
            this.updateIntersectionAB(a, b);
        }
        this.addNodeSections(a, b);
    }

    private void updateIntersectionAB(NodeSection a, NodeSection b) {
        if (NodeSection.isAreaArea(a, b)) {
            this.updateAreaAreaCross(a, b);
        }
        this.updateNodeLocation(a, b);
    }

    private void updateAreaAreaCross(NodeSection a, NodeSection b) {
        boolean isProper = NodeSection.isProper(a, b);
        if (isProper || PolygonNodeTopology.isCrossing(a.nodePt(), a.getVertex(0), a.getVertex(1), b.getVertex(0), b.getVertex(1))) {
            this.updateDim(0, 0, 2);
        }
    }

    private void updateNodeLocation(NodeSection a, NodeSection b) {
        Coordinate pt = a.nodePt();
        int locA = this.geomA.locateNode(pt, a.getPolygonal());
        int locB = this.geomB.locateNode(pt, b.getPolygonal());
        this.updateDim(locA, locB, 0);
    }

    private void addNodeSections(NodeSection ns0, NodeSection ns1) {
        NodeSections sections = this.getNodeSections(ns0.nodePt());
        sections.addNodeSection(ns0);
        sections.addNodeSection(ns1);
    }

    public void addPointOnPointInterior(Coordinate pt) {
        this.updateDim(0, 0, 0);
    }

    public void addPointOnPointExterior(boolean isGeomA, Coordinate pt) {
        this.updateDim(isGeomA, 0, 2, 0);
    }

    public void addPointOnGeometry(boolean isA, int locTarget, int dimTarget, Coordinate pt) {
        this.updateDim(isA, 0, locTarget, 0);
        switch (dimTarget) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                this.updateDim(isA, 2, 0, 2);
                this.updateDim(isA, 2, 1, 1);
                return;
            }
        }
        throw new IllegalStateException("Unknown target dimension: " + dimTarget);
    }

    public void addLineEndOnGeometry(boolean isLineA, int locLineEnd, int locTarget, int dimTarget, Coordinate pt) {
        this.updateDim(isLineA, locLineEnd, locTarget, 0);
        switch (dimTarget) {
            case 0: {
                return;
            }
            case 1: {
                this.addLineEndOnLine(isLineA, locLineEnd, locTarget, pt);
                return;
            }
            case 2: {
                this.addLineEndOnArea(isLineA, locLineEnd, locTarget, pt);
                return;
            }
        }
        throw new IllegalStateException("Unknown target dimension: " + dimTarget);
    }

    private void addLineEndOnLine(boolean isLineA, int locLineEnd, int locLine, Coordinate pt) {
        if (locLine == 2) {
            this.updateDim(isLineA, 0, 2, 1);
        }
    }

    private void addLineEndOnArea(boolean isLineA, int locLineEnd, int locArea, Coordinate pt) {
        if (locArea != 1) {
            this.updateDim(isLineA, 0, locArea, 1);
            this.updateDim(isLineA, 2, locArea, 2);
        }
    }

    public void addAreaVertex(boolean isAreaA, int locArea, int locTarget, int dimTarget, Coordinate pt) {
        if (locTarget == 2) {
            this.updateDim(isAreaA, 0, 2, 2);
            if (locArea == 1) {
                this.updateDim(isAreaA, 1, 2, 1);
                this.updateDim(isAreaA, 2, 2, 2);
            }
            return;
        }
        switch (dimTarget) {
            case 0: {
                this.addAreaVertexOnPoint(isAreaA, locArea, pt);
                return;
            }
            case 1: {
                this.addAreaVertexOnLine(isAreaA, locArea, locTarget, pt);
                return;
            }
            case 2: {
                this.addAreaVertexOnArea(isAreaA, locArea, locTarget, pt);
                return;
            }
        }
        throw new IllegalStateException("Unknown target dimension: " + dimTarget);
    }

    private void addAreaVertexOnPoint(boolean isAreaA, int locArea, Coordinate pt) {
        this.updateDim(isAreaA, locArea, 0, 0);
        this.updateDim(isAreaA, 0, 2, 2);
        if (locArea == 1) {
            this.updateDim(isAreaA, 1, 2, 1);
            this.updateDim(isAreaA, 2, 2, 2);
        }
    }

    private void addAreaVertexOnLine(boolean isAreaA, int locArea, int locTarget, Coordinate pt) {
        this.updateDim(isAreaA, locArea, locTarget, 0);
        if (locArea == 0) {
            this.updateDim(isAreaA, 0, 2, 2);
        }
    }

    public void addAreaVertexOnArea(boolean isAreaA, int locArea, int locTarget, Coordinate pt) {
        if (locTarget == 1) {
            if (locArea == 1) {
                this.updateDim(isAreaA, 1, 1, 0);
            } else {
                this.updateDim(isAreaA, 0, 0, 2);
                this.updateDim(isAreaA, 0, 1, 1);
                this.updateDim(isAreaA, 0, 2, 2);
            }
        } else {
            this.updateDim(isAreaA, 0, locTarget, 2);
            if (locArea == 1) {
                this.updateDim(isAreaA, 1, locTarget, 1);
                this.updateDim(isAreaA, 2, locTarget, 2);
            }
        }
    }

    public void evaluateNodes() {
        for (NodeSections nodeSections : this.nodeMap.values()) {
            if (!nodeSections.hasInteractionAB()) continue;
            this.evaluateNode(nodeSections);
            if (!this.isResultKnown()) continue;
            return;
        }
    }

    private void evaluateNode(NodeSections nodeSections) {
        Coordinate p = nodeSections.getCoordinate();
        RelateNode node = nodeSections.createNode();
        boolean isAreaInteriorA = this.geomA.isNodeInArea(p, nodeSections.getPolygonal(true));
        boolean isAreaInteriorB = this.geomB.isNodeInArea(p, nodeSections.getPolygonal(false));
        node.finish(isAreaInteriorA, isAreaInteriorB);
        this.evaluateNodeEdges(node);
    }

    private void evaluateNodeEdges(RelateNode node) {
        for (RelateEdge e2 : node.getEdges()) {
            if (this.isAreaArea()) {
                this.updateDim(e2.location(true, 1), e2.location(false, 1), 2);
                this.updateDim(e2.location(true, 2), e2.location(false, 2), 2);
            }
            this.updateDim(e2.location(true, 0), e2.location(false, 0), 1);
        }
    }
}

