/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectSet;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class CoordinateOperationSet
extends IdentifiedObjectSet<CoordinateOperation> {
    private final Map<String, Integer> projections = new HashMap<String, Integer>();

    CoordinateOperationSet(AuthorityFactory factory) {
        super(factory, CoordinateOperation.class);
    }

    final void addAuthorityCode(String code, Integer crs) {
        if (crs != null) {
            this.projections.put(code, crs);
        }
        this.addAuthorityCode(code);
    }

    @Override
    protected String getAuthorityCode(CoordinateOperation object) {
        Identifier id = IdentifiedObjects.getIdentifier(object, Citations.EPSG);
        return id != null ? id.getCode() : IdentifiedObjects.getIdentifierOrName(object);
    }

    @Override
    protected CoordinateOperation createObject(String code) throws FactoryException {
        CoordinateReferenceSystem crs;
        Integer base = this.projections.get(code);
        if (base != null && (crs = ((CRSAuthorityFactory)this.factory).createCoordinateReferenceSystem(String.valueOf(base))) instanceof GeneralDerivedCRS) {
            return ((GeneralDerivedCRS)crs).getConversionFromBase();
        }
        return ((CoordinateOperationAuthorityFactory)this.factory).createCoordinateOperation(code);
    }
}

