/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.List;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.aggregate.AggAvg;
import org.apache.jena.sparql.expr.aggregate.AggAvgDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.AggCountDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCustom;
import org.apache.jena.sparql.expr.aggregate.AggFoldList;
import org.apache.jena.sparql.expr.aggregate.AggFoldMap;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcat;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcatDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMax;
import org.apache.jena.sparql.expr.aggregate.AggMaxDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMedian;
import org.apache.jena.sparql.expr.aggregate.AggMedianDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMin;
import org.apache.jena.sparql.expr.aggregate.AggMinDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMode;
import org.apache.jena.sparql.expr.aggregate.AggModeDistinct;
import org.apache.jena.sparql.expr.aggregate.AggNull;
import org.apache.jena.sparql.expr.aggregate.AggSample;
import org.apache.jena.sparql.expr.aggregate.AggSampleDistinct;
import org.apache.jena.sparql.expr.aggregate.AggSum;
import org.apache.jena.sparql.expr.aggregate.AggSumDistinct;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.Args;

public class AggregatorFactory {
    public static Aggregator createCount(boolean distinct) {
        return distinct ? new AggCountDistinct() : new AggCount();
    }

    public static Aggregator createCountExpr(boolean distinct, Expr expr) {
        return distinct ? new AggCountVarDistinct(expr) : new AggCountVar(expr);
    }

    public static Aggregator createSum(boolean distinct, Expr expr) {
        return distinct ? new AggSumDistinct(expr) : new AggSum(expr);
    }

    public static Aggregator createMin(boolean distinct, Expr expr) {
        return distinct ? new AggMinDistinct(expr) : new AggMin(expr);
    }

    public static Aggregator createMax(boolean distinct, Expr expr) {
        return distinct ? new AggMaxDistinct(expr) : new AggMax(expr);
    }

    public static Aggregator createAvg(boolean distinct, Expr expr) {
        return distinct ? new AggAvgDistinct(expr) : new AggAvg(expr);
    }

    public static Aggregator createMedian(boolean distinct, Expr expr) {
        return distinct ? new AggMedianDistinct(expr) : new AggMedian(expr);
    }

    public static Aggregator createMode(boolean distinct, Expr expr) {
        return distinct ? new AggModeDistinct(expr) : new AggMode(expr);
    }

    public static Aggregator createSample(boolean distinct, Expr expr) {
        return distinct ? new AggSampleDistinct(expr) : new AggSample(expr);
    }

    public static Aggregator createGroupConcat(boolean distinct, Expr expr, String separator, ExprList orderedBy) {
        if (orderedBy != null && !orderedBy.isEmpty()) {
            throw new NotImplemented("GROUP_CONCAT / ORDER BY not implemented yet");
        }
        return distinct ? new AggGroupConcatDistinct(expr, separator) : new AggGroupConcat(expr, separator);
    }

    public static Aggregator createAggNull() {
        return new AggNull();
    }

    public static Aggregator createFold(boolean distinct, Expr expr1, Expr expr2, List<SortCondition> orderBy) {
        if (expr2 == null) {
            return new AggFoldList(distinct, expr1, orderBy);
        }
        return new AggFoldMap(expr1, expr2, orderBy);
    }

    public static Aggregator createCustom(String iri2, Args a) {
        return AggregatorFactory.createCustom(iri2, a.distinct, ExprList.copy(a));
    }

    public static Aggregator createCustom(String iri2, boolean distinct, Expr expr) {
        return AggregatorFactory.createCustom(iri2, distinct, new ExprList(expr));
    }

    public static Aggregator createCustom(String iri2, boolean distinct, ExprList exprs) {
        if (!AggregateRegistry.isRegistered(iri2)) {
            Log.warn(AggregatorFactory.class, "Not registered: custom aggregate <" + iri2 + ">");
        }
        return new AggCustom(iri2, distinct, exprs);
    }
}

