/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDigest;
import org.apache.jena.sparql.serializer.SerializationContext;

public abstract class ExprDigest
extends ExprFunction1 {
    private final String digestName;
    private final String printName;
    private final Cache<NodeValue, NodeValue> cache = CacheFactory.createOneSlotCache();

    public ExprDigest(Expr expr, String symbol, String printName, String digestName) {
        super(expr, symbol);
        this.digestName = digestName;
        this.printName = printName;
    }

    @Override
    public NodeValue eval(NodeValue v) {
        return this.cache.get(v, x -> this.calculate((NodeValue)x));
    }

    private NodeValue calculate(NodeValue v) {
        return NodeValueDigest.calculateDigest(v, this.digestName);
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return this.printName;
    }
}

