/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.access.SecurityContextView;
import org.apache.jena.fuseki.access.SecurityRegistry;
import org.apache.jena.fuseki.access.VocabSecurity;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class AssemblerSecurityRegistry
extends AssemblerBase {
    private static final boolean SKIP_ALLGRAPH = true;

    @Override
    public AuthorizationService open(Assembler a, Resource root2, Mode mode) {
        SecurityRegistry registry = new SecurityRegistry();
        StmtIterator sIter = root2.listProperties(VocabSecurity.pEntry);
        if (!sIter.hasNext()) {
            throw new AssemblerException(root2, "No access entries");
        }
        ListValuedMap map = MultiMapUtils.newListValuedHashMap();
        sIter.forEachRemaining(s -> {
            RDFNode n = s.getObject();
            if (!n.isResource()) {
                throw new AssemblerException(root2, "Found access:entry with non-resource");
            }
            Resource r = (Resource)n;
            GNode entry = new GNode(root2.getModel().getGraph(), n.asNode());
            if (GraphList.isListNode(entry)) {
                this.parseList(map, root2, entry);
            } else if (r.hasProperty(VocabSecurity.pUser) || r.hasProperty(VocabSecurity.pGraphs)) {
                this.parseStruct(map, root2, r);
            } else {
                throw new AssemblerException(root2, "Found access:entry but failed to parse the object: " + String.valueOf(s.getSubject()));
            }
        });
        map.keySet().forEach(u -> {
            SecurityContextView sCxt = new SecurityContextView(map.get(u));
            registry.put(u, sCxt);
        });
        return registry;
    }

    private void parseList(MultiValuedMap<String, Node> map, Resource root2, GNode entry) {
        List<Node> members = GraphList.members(entry);
        if (members.isEmpty()) {
            throw new AssemblerException(root2, "Found access:entry with an empty list");
        }
        Node userNode = members.get(0);
        if (!Util.isSimpleString(userNode)) {
            throw new AssemblerException(root2, "User name is not a string: " + NodeFmtLib.strTTL(userNode));
        }
        String user = userNode.getLiteralLexicalForm();
        List<Node> graphs = members.subList(1, members.size());
        this.accessEntries(root2, map, user, graphs);
    }

    private void parseStruct(MultiValuedMap<String, Node> map, Resource root2, Resource r) {
        if (!GraphUtils.exactlyOneProperty(r, VocabSecurity.pUser)) {
            throw new AssemblerException(root2, "Expected exactly one access:user property for " + String.valueOf(r));
        }
        if (!GraphUtils.exactlyOneProperty(r, VocabSecurity.pGraphs)) {
            throw new AssemblerException(root2, "Expected exactly one access:graphs property for " + String.valueOf(r));
        }
        String user = GraphUtils.getStringValue(r, VocabSecurity.pUser);
        r.listProperties(VocabSecurity.pGraphs).mapWith(s -> s.getObject()).forEachRemaining(x -> {
            ArrayList<Node> graphs = new ArrayList<Node>();
            if (x.isURIResource()) {
                graphs.add(x.asNode());
            } else {
                RDFList list = x.as(RDFList.class);
                list.iterator().forEachRemaining(rn -> graphs.add(rn.asNode()));
            }
            this.accessEntries(root2, map, user, graphs);
        });
    }

    private Node graphLabel(Node x, Resource root2) {
        if (SecurityContext.allGraphsStr.equals(x)) {
            x = SecurityContext.allGraphs;
        }
        if (SecurityContext.allNamedGraphsStr.equals(x)) {
            x = SecurityContext.allNamedGraphs;
        }
        if (!x.isURI()) {
            throw new AssemblerException(root2, "Not a graph name: " + String.valueOf(x));
        }
        return x;
    }

    private void accessEntries(Resource root2, MultiValuedMap<String, Node> map, String user, List<Node> _graphs) {
        Set<Node> graphs = _graphs.stream().map(n -> this.graphLabel((Node)n, root2)).collect(Collectors.toSet());
        if (graphs.contains(SecurityContext.allGraphs)) {
            map.remove(user);
            map.put(user, SecurityContext.allGraphs);
            return;
        }
        if (graphs.contains(SecurityContext.allNamedGraphs)) {
            boolean dft = this.dftPresent(graphs);
            Node x = SecurityContext.allNamedGraphs;
            if (dft) {
                x = SecurityContext.allGraphs;
            }
            map.remove(user);
            map.put(user, x);
            return;
        }
        if (graphs.contains(SecurityContext.allGraphs)) {
            Log.warn(this, "Graph name '" + String.valueOf(SecurityContext.allGraphsStr) + "' not supported yet");
            graphs.remove(SecurityContext.allGraphs);
        }
        if (graphs.contains(SecurityContext.allNamedGraphs)) {
            Log.warn(this, "Graph name '" + String.valueOf(SecurityContext.allNamedGraphsStr) + "' not supported yet");
            graphs.remove(SecurityContext.allNamedGraphs);
        }
        map.putAll(user, graphs);
    }

    private boolean dftPresent(Collection<Node> nodes) {
        return nodes.stream().anyMatch(n -> Quad.isDefaultGraph(n));
    }
}

