/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class BitSetMapper {
    public static BitSet toBitSet(List<Var> referenceList, Binding binding) {
        int n = referenceList.size();
        BitSet result = new BitSet(n);
        if (n < binding.size()) {
            for (int i = 0; i < n; ++i) {
                Var var = referenceList.get(i);
                if (!binding.contains(var)) continue;
                result.set(i);
            }
        } else {
            Iterator<Var> it = binding.vars();
            while (it.hasNext()) {
                Var var = it.next();
                int idx = referenceList.indexOf((Object)var);
                if (idx == -1) continue;
                result.set(idx);
            }
        }
        return result;
    }

    public static <T> List<T> toList(List<T> referenceList, BitSet key) {
        ArrayList<T> result = new ArrayList<T>(referenceList.size());
        int i = key.nextSetBit(0);
        while (i >= 0) {
            T item = referenceList.get(i);
            result.add(item);
            i = key.nextSetBit(i + 1);
        }
        return result;
    }
}

