/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;

public abstract class AbstractDatasetGraphAddDelete
extends DatasetGraphWrapper {
    private static final int DeleteBufferSize = 10000;

    public AbstractDatasetGraphAddDelete(DatasetGraph dsg) {
        super(dsg);
    }

    protected abstract void actionAdd(Node var1, Node var2, Node var3, Node var4);

    protected abstract void actionDelete(Node var1, Node var2, Node var3, Node var4);

    public void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void add(Node g, Node s, Node p, Node o) {
        this.actionAdd(g, s, p, o);
    }

    public void delete(Node g, Node s, Node p, Node o) {
        this.actionDelete(g, s, p, o);
    }

    public void addGraph(Node graphName, Graph graph) {
        graph.find(null, null, null).forEachRemaining(t -> this.add(graphName, t.getSubject(), t.getPredicate(), t.getObject()));
    }

    public void removeGraph(Node graphName) {
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
    }

    public void clear() {
        this.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this.get(), (Node)graphNode);
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        int len;
        Quad[] buffer = new Quad[10000];
        do {
            Iterator iter = this.find(g, s, p, o);
            for (len = 0; len < 10000 && iter.hasNext(); ++len) {
                buffer[len] = (Quad)iter.next();
            }
            for (int i = 0; i < len; ++i) {
                this.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (len >= 10000);
    }
}

