/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.change;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresMailboxChangeDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresMailboxChangeTable.TABLE}).addIndex(new PostgresIndex[]{PostgresMailboxChangeTable.INDEX}).build();

    public static interface PostgresMailboxChangeTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"mailbox_change");
        public static final Field<String> ACCOUNT_ID = DSL.field((String)"account_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<UUID> STATE = DSL.field((String)"state", (DataType)SQLDataType.UUID.notNull());
        public static final Field<OffsetDateTime> DATE = DSL.field((String)"date", (DataType)SQLDataType.TIMESTAMPWITHTIMEZONE.notNull());
        public static final Field<Boolean> IS_SHARED = DSL.field((String)"is_shared", (DataType)SQLDataType.BOOLEAN.notNull());
        public static final Field<Boolean> IS_COUNT_CHANGE = DSL.field((String)"is_count_change", (DataType)SQLDataType.BOOLEAN.notNull());
        public static final Field<UUID[]> CREATED = DSL.field((String)"created", (DataType)SQLDataType.UUID.getArrayDataType().notNull());
        public static final Field<UUID[]> UPDATED = DSL.field((String)"updated", (DataType)SQLDataType.UUID.getArrayDataType().notNull());
        public static final Field<UUID[]> DESTROYED = DSL.field((String)"destroyed", (DataType)SQLDataType.UUID.getArrayDataType().notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(ACCOUNT_ID).column(STATE).column(DATE).column(IS_SHARED).column(IS_COUNT_CHANGE).column(CREATED).column(UPDATED).column(DESTROYED).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{ACCOUNT_ID, STATE, IS_SHARED}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex INDEX = PostgresIndex.name((String)"index_mailbox_change_date").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{DATE}));
    }
}

