/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.postgres;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.stream.Stream;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.postgres.PostgresMailRepositoryDataDefinition;
import org.jooq.Field;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailRepositoryUrlStore
implements MailRepositoryUrlStore {
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresMailRepositoryUrlStore(@Named(value="default") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public void add(MailRepositoryUrl url) {
        this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.insertInto(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryUrlTable.TABLE_NAME, PostgresMailRepositoryDataDefinition.PostgresMailRepositoryUrlTable.URL).values((Object)url.asString()).onConflict(new Field[]{PostgresMailRepositoryDataDefinition.PostgresMailRepositoryUrlTable.URL}).doNothing())).block();
    }

    public Stream<MailRepositoryUrl> listDistinct() {
        return this.postgresExecutor.executeRows(context -> Flux.from((Publisher)context.selectFrom(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryUrlTable.TABLE_NAME))).map(record -> MailRepositoryUrl.from((String)((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryUrlTable.URL)))).toStream();
    }

    public boolean contains(MailRepositoryUrl url) {
        return this.listDistinct().anyMatch(arg_0 -> ((MailRepositoryUrl)url).equals(arg_0));
    }
}

