/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.search;

import jakarta.inject.Inject;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AllSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    public AllSearchOverride(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return this.isAll(searchQuery) || this.isFromOne(searchQuery) || this.isEmpty(searchQuery);
    }

    private boolean isAll(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(MessageUid.MIN_VALUE, MessageUid.MAX_VALUE)})) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isFromOne(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.all()) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isEmpty(SearchQuery searchQuery) {
        return searchQuery.getCriteria().isEmpty() && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        return Mono.fromCallable(() -> new PostgresMailboxMessageDAO(this.executorFactory.create(session.getUser().getDomainPart()))).flatMapMany(dao -> dao.listAllMessageUid((PostgresMailboxId)mailbox.getMailboxId()));
    }
}

