/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolInvocationLogDetails;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolInvocationLogShutdownHook;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolInvocationLogger;
import com.unboundid.util.CommandLineToolInteractiveModeProcessor;
import com.unboundid.util.CommandLineToolShutdownHook;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.Extensible;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.MinimalLogFormatter;
import com.unboundid.util.NotNull;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordFileReader;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.TeeOutputStream;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentHelper;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @Nullable
    private BooleanArgument appendToOutputFileArgument = null;
    @Nullable
    private BooleanArgument enableDebugArgument = null;
    @Nullable
    private BooleanArgument helpArgument = null;
    @Nullable
    private BooleanArgument helpDebugArgument = null;
    @Nullable
    private BooleanArgument helpSASLArgument = null;
    @Nullable
    private BooleanArgument helpSubcommandsArgument = null;
    @Nullable
    private BooleanArgument includeDebugStackTracesArgument = null;
    @Nullable
    private BooleanArgument interactiveArgument = null;
    @Nullable
    private BooleanArgument teeOutputArgument = null;
    @Nullable
    private BooleanArgument useMultiLineDebugMessagesArgument = null;
    @Nullable
    private BooleanArgument versionArgument = null;
    @Nullable
    private FileArgument debugLogFileArgument = null;
    @Nullable
    private FileArgument outputFileArgument = null;
    @NotNull
    private final List<BooleanArgument> enableSSLDebuggingArguments;
    @NotNull
    private final PasswordFileReader passwordFileReader;
    @NotNull
    private final PrintStream originalOut;
    @NotNull
    private final PrintStream originalErr;
    @NotNull
    private volatile PrintStream out;
    @NotNull
    private volatile PrintStream err;
    @Nullable
    private StringArgument debugLogCategoryArgument = null;
    @Nullable
    private StringArgument debugLogLevelArgument = null;

    public CommandLineTool(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        if (CryptoHelper.usingFIPSMode()) {
            Debug.debug(Level.INFO, DebugType.OTHER, "Running in FIPS-compliant mode.");
        }
        this.out = outStream == null ? NullOutputStream.getPrintStream() : new PrintStream(outStream);
        this.err = errStream == null ? NullOutputStream.getPrintStream() : new PrintStream(errStream);
        this.originalOut = this.out;
        this.originalErr = this.err;
        this.passwordFileReader = new PasswordFileReader(this.out, this.err);
        this.enableSSLDebuggingArguments = new ArrayList<BooleanArgument>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResultCode runTool(String ... args) {
        ArgumentParser parser;
        try {
            parser = this.createArgumentParser();
            boolean exceptionFromParsingWithNoArgumentsExplicitlyProvided = false;
            if (this.supportsInteractiveMode() && this.defaultsToInteractiveMode() && (args == null || args.length == 0)) {
                try {
                    parser.parse(StaticUtils.NO_STRINGS);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    exceptionFromParsingWithNoArgumentsExplicitlyProvided = true;
                }
            } else if (args == null) {
                parser.parse(StaticUtils.NO_STRINGS);
            } else {
                parser.parse(args);
            }
            File generatedPropertiesFile = parser.getGeneratedPropertiesFile();
            if (this.supportsPropertiesFile() && generatedPropertiesFile != null) {
                this.wrapOut(0, WRAP_COLUMN, UtilityMessages.INFO_CL_TOOL_WROTE_PROPERTIES_FILE.get(generatedPropertiesFile.getAbsolutePath()));
                return ResultCode.SUCCESS;
            }
            if (this.helpArgument.isPresent()) {
                this.out(parser.getUsageString(WRAP_COLUMN));
                this.displayExampleUsages(parser);
                return ResultCode.SUCCESS;
            }
            if (this.helpSASLArgument != null && this.helpSASLArgument.isPresent()) {
                String mechanism = null;
                Argument argument = parser.getNamedArgument("saslOption");
                if (argument != null && argument.isPresent()) {
                    for (String value : argument.getValueStringRepresentations(false)) {
                        String mech;
                        String lowerValue = StaticUtils.toLowerCase(value);
                        if (!lowerValue.startsWith("mech=") || (mech = value.substring(5).trim()).isEmpty()) continue;
                        mechanism = mech;
                        break;
                    }
                }
                this.out(SASLUtils.getUsageString(mechanism, WRAP_COLUMN));
                return ResultCode.SUCCESS;
            }
            if (this.helpDebugArgument != null && this.helpDebugArgument.isPresent()) {
                this.printDebugHelp();
                return ResultCode.SUCCESS;
            }
            if (this.helpSubcommandsArgument != null && this.helpSubcommandsArgument.isPresent()) {
                TreeMap<String, SubCommand> subCommands = CommandLineTool.getSortedSubCommands(parser);
                for (SubCommand sc : subCommands.values()) {
                    StringBuilder nameBuffer = new StringBuilder();
                    Iterator<String> nameIterator = sc.getNames(false).iterator();
                    while (nameIterator.hasNext()) {
                        nameBuffer.append(nameIterator.next());
                        if (!nameIterator.hasNext()) continue;
                        nameBuffer.append(", ");
                    }
                    this.out(nameBuffer.toString());
                    for (String descriptionLine : StaticUtils.wrapLine(sc.getDescription(), WRAP_COLUMN)) {
                        this.out("  " + descriptionLine);
                    }
                    this.out(new Object[0]);
                }
                this.wrapOut(0, WRAP_COLUMN, UtilityMessages.INFO_CL_TOOL_USE_SUBCOMMAND_HELP.get(this.getToolName()));
                return ResultCode.SUCCESS;
            }
            if (this.versionArgument != null && this.versionArgument.isPresent()) {
                this.out(this.getToolVersion());
                return ResultCode.SUCCESS;
            }
            if (this.enableDebugArgument != null && this.enableDebugArgument.isPresent()) {
                try {
                    this.enableDebugLogging();
                }
                catch (LDAPException e) {
                    this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                    return e.getResultCode();
                }
            }
            for (BooleanArgument booleanArgument : this.enableSSLDebuggingArguments) {
                if (!booleanArgument.isPresent()) continue;
                StaticUtils.setSystemProperty("javax.net.debug", "all");
            }
            boolean extendedValidationDone = false;
            if (this.interactiveArgument != null && (this.interactiveArgument.isPresent() || this.defaultsToInteractiveMode() && (args == null || args.length == 0) && (parser.getArgumentsSetFromPropertiesFile().isEmpty() || exceptionFromParsingWithNoArgumentsExplicitlyProvided))) {
                try {
                    List<String> list = this.requestToolArgumentsInteractively(parser);
                    if (list == null) {
                        CommandLineToolInteractiveModeProcessor processor = new CommandLineToolInteractiveModeProcessor(this, parser);
                        processor.doInteractiveModeProcessing();
                        extendedValidationDone = true;
                    } else {
                        ArgumentHelper.reset(parser);
                        parser.parse(StaticUtils.toArray(list, String.class));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    String message = lDAPException.getMessage();
                    if (message != null && !message.isEmpty()) {
                        this.err(message);
                    }
                    return lDAPException.getResultCode();
                }
            }
            if (!extendedValidationDone) {
                this.doExtendedArgumentValidation();
            }
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            this.err(ae.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        PrintStream outputFileStream = null;
        if (this.outputFileArgument != null && this.outputFileArgument.isPresent()) {
            File outputFile = this.outputFileArgument.getValue();
            boolean append = this.appendToOutputFileArgument != null && this.appendToOutputFileArgument.isPresent();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(outputFile, append);
                outputFileStream = new PrintStream((OutputStream)fileOutputStream, true, "UTF-8");
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                this.err(UtilityMessages.ERR_CL_TOOL_ERROR_CREATING_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(exception)));
                return ResultCode.LOCAL_ERROR;
            }
            if (this.teeOutputArgument != null && this.teeOutputArgument.isPresent()) {
                this.out = new PrintStream(new TeeOutputStream(this.out, outputFileStream));
                this.err = new PrintStream(new TeeOutputStream(this.err, outputFileStream));
            } else {
                this.out = outputFileStream;
                this.err = outputFileStream;
            }
        }
        try {
            List<String> argsSetFromPropertiesFiles = parser.getArgumentsSetFromPropertiesFile();
            if (!argsSetFromPropertiesFiles.isEmpty() && !parser.suppressPropertiesFileComment()) {
                for (String string : StaticUtils.wrapLine(UtilityMessages.INFO_CL_TOOL_ARGS_FROM_PROPERTIES_FILE.get(parser.getPropertiesFileUsed().getPath()), WRAP_COLUMN)) {
                    this.out("# ", string);
                }
                StringBuilder buffer = new StringBuilder();
                for (String s : argsSetFromPropertiesFiles) {
                    if (s.startsWith("-")) {
                        if (buffer.length() > 0) {
                            this.out(buffer);
                            buffer.setLength(0);
                        }
                        buffer.append("#      ");
                        buffer.append(s);
                        continue;
                    }
                    if (buffer.length() == 0) {
                        buffer.append("#      ");
                    } else {
                        buffer.append(' ');
                    }
                    buffer.append(StaticUtils.cleanExampleCommandLineArgument(s));
                }
                if (buffer.length() > 0) {
                    this.out(buffer);
                }
                this.out(new Object[0]);
            }
            CommandLineToolShutdownHook shutdownHook = null;
            AtomicReference<ResultCode> atomicReference = new AtomicReference<ResultCode>();
            if (this.registerShutdownHook()) {
                shutdownHook = new CommandLineToolShutdownHook(this, atomicReference);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            ToolInvocationLogDetails logDetails = ToolInvocationLogger.getLogMessageDetails(this.getToolName(), this.logToolInvocationByDefault(), this.getErr());
            ToolInvocationLogShutdownHook logShutdownHook = null;
            if (logDetails.logInvocation()) {
                File propertiesFile;
                HashSet<Argument> argumentsSetFromPropertiesFile = new HashSet<Argument>(StaticUtils.computeMapCapacity(10));
                ArrayList<ObjectPair<String, String>> propertiesFileArgList = new ArrayList<ObjectPair<String, String>>(10);
                CommandLineTool.getToolInvocationPropertiesFileArguments(parser, argumentsSetFromPropertiesFile, propertiesFileArgList);
                ArrayList<ObjectPair<String, String>> providedArgList = new ArrayList<ObjectPair<String, String>>(10);
                CommandLineTool.getToolInvocationProvidedArguments(parser, argumentsSetFromPropertiesFile, providedArgList);
                logShutdownHook = new ToolInvocationLogShutdownHook(logDetails);
                Runtime.getRuntime().addShutdownHook(logShutdownHook);
                String propertiesFilePath = propertiesFileArgList.isEmpty() ? "" : ((propertiesFile = parser.getPropertiesFileUsed()) == null ? "" : propertiesFile.getAbsolutePath());
                ToolInvocationLogger.logLaunchMessage(logDetails, providedArgList, propertiesFileArgList, propertiesFilePath);
            }
            try {
                atomicReference.set(this.doToolProcessing());
            }
            catch (Throwable t) {
                Debug.debugException(t);
                this.err(StaticUtils.getExceptionMessage(t));
                atomicReference.set(ResultCode.LOCAL_ERROR);
            }
            finally {
                if (logShutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(logShutdownHook);
                    String completionMessage = this.getToolCompletionMessage();
                    if (completionMessage == null) {
                        completionMessage = atomicReference.get().getName();
                    }
                    ToolInvocationLogger.logCompletionMessage(logDetails, atomicReference.get().intValue(), completionMessage);
                }
                if (shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
            }
            ResultCode resultCode = atomicReference.get();
            return resultCode;
        }
        finally {
            if (outputFileStream != null) {
                outputFileStream.close();
            }
        }
    }

    private static void getToolInvocationProvidedArguments(@NotNull ArgumentParser parser, @NotNull Set<Argument> argumentsSetFromPropertiesFile, @NotNull List<ObjectPair<String, String>> argList) {
        Object noValue = null;
        SubCommand subCommand = parser.getSelectedSubCommand();
        if (subCommand != null) {
            argList.add(new ObjectPair<String, Object>(subCommand.getPrimaryName(), noValue));
        }
        for (Argument arg : parser.getNamedArguments()) {
            if (!arg.isPresent() || argumentsSetFromPropertiesFile.contains(arg)) continue;
            if (arg.takesValue()) {
                for (String value : arg.getValueStringRepresentations(false)) {
                    if (arg.isSensitive()) {
                        argList.add(new ObjectPair<String, String>(arg.getIdentifierString(), "*****REDACTED*****"));
                        continue;
                    }
                    argList.add(new ObjectPair<String, String>(arg.getIdentifierString(), value));
                }
                continue;
            }
            argList.add(new ObjectPair<String, Object>(arg.getIdentifierString(), noValue));
        }
        if (subCommand != null) {
            CommandLineTool.getToolInvocationProvidedArguments(subCommand.getArgumentParser(), argumentsSetFromPropertiesFile, argList);
        }
        for (String trailingArgument : parser.getTrailingArguments()) {
            argList.add(new ObjectPair<String, Object>(trailingArgument, noValue));
        }
    }

    private static void getToolInvocationPropertiesFileArguments(@NotNull ArgumentParser parser, @NotNull Set<Argument> argumentsSetFromPropertiesFile, @NotNull List<ObjectPair<String, String>> argList) {
        SubCommand subCommand = parser.getSelectedSubCommand();
        ArgumentParser subCommandParser = subCommand == null ? null : subCommand.getArgumentParser();
        Object noValue = null;
        Iterator<String> iterator = parser.getArgumentsSetFromPropertiesFile().iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.startsWith("-")) {
                Argument a;
                if (arg.startsWith("--")) {
                    String longIdentifier = arg.substring(2);
                    a = parser.getNamedArgument(longIdentifier);
                    if (a == null && subCommandParser != null) {
                        a = subCommandParser.getNamedArgument(longIdentifier);
                    }
                } else {
                    char shortIdentifier = arg.charAt(1);
                    a = parser.getNamedArgument(Character.valueOf(shortIdentifier));
                    if (a == null && subCommandParser != null) {
                        a = subCommandParser.getNamedArgument(Character.valueOf(shortIdentifier));
                    }
                }
                if (a == null) continue;
                argumentsSetFromPropertiesFile.add(a);
                if (a.takesValue()) {
                    String value = iterator.next();
                    if (a.isSensitive()) {
                        argList.add(new ObjectPair<String, Object>(a.getIdentifierString(), noValue));
                        continue;
                    }
                    argList.add(new ObjectPair<String, String>(a.getIdentifierString(), value));
                    continue;
                }
                argList.add(new ObjectPair<String, Object>(a.getIdentifierString(), noValue));
                continue;
            }
            argList.add(new ObjectPair<String, Object>(arg, noValue));
        }
    }

    @NotNull
    private static TreeMap<String, SubCommand> getSortedSubCommands(@NotNull ArgumentParser parser) {
        TreeMap<String, SubCommand> m = new TreeMap<String, SubCommand>();
        for (SubCommand sc : parser.getSubCommands()) {
            m.put(sc.getPrimaryName(), sc);
        }
        return m;
    }

    private void displayExampleUsages(@NotNull ArgumentParser parser) {
        LinkedHashMap<String[], String> examples = parser != null && parser.getSelectedSubCommand() != null ? parser.getSelectedSubCommand().getExampleUsages() : this.getExampleUsages();
        if (examples == null || examples.isEmpty()) {
            return;
        }
        this.out(new Object[]{UtilityMessages.INFO_CL_TOOL_LABEL_EXAMPLES});
        for (Map.Entry<String[], String> e : examples.entrySet()) {
            this.out(new Object[0]);
            this.wrapOut(2, WRAP_COLUMN, e.getValue());
            this.out(new Object[0]);
            StringBuilder buffer = new StringBuilder();
            buffer.append("    ");
            buffer.append(this.getToolName());
            String[] args = e.getKey();
            for (int i = 0; i < args.length; ++i) {
                ExampleCommandLineArgument cleanArg;
                buffer.append(' ');
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                        cleanArg = ExampleCommandLineArgument.getCleanArgument(args[i + 1]);
                        arg = arg + ' ' + cleanArg.getLocalForm();
                        ++i;
                    }
                } else {
                    cleanArg = ExampleCommandLineArgument.getCleanArgument(arg);
                    arg = cleanArg.getLocalForm();
                }
                if (buffer.length() + arg.length() + 2 < WRAP_COLUMN) {
                    buffer.append(arg);
                    continue;
                }
                buffer.append(StaticUtils.getCommandLineContinuationString());
                this.out(buffer.toString());
                buffer.setLength(0);
                buffer.append("         ");
                buffer.append(arg);
            }
            this.out(buffer.toString());
        }
    }

    @NotNull
    public abstract String getToolName();

    @Nullable
    public abstract String getToolDescription();

    @Nullable
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.emptyList();
    }

    @Nullable
    public String getToolVersion() {
        return null;
    }

    public int getMinTrailingArguments() {
        return 0;
    }

    public int getMaxTrailingArguments() {
        return 0;
    }

    @Nullable
    public String getTrailingArgumentsPlaceholder() {
        return null;
    }

    public boolean supportsInteractiveMode() {
        return false;
    }

    public boolean defaultsToInteractiveMode() {
        return false;
    }

    @Nullable
    protected List<String> requestToolArgumentsInteractively(@NotNull ArgumentParser parser) throws LDAPException {
        return null;
    }

    public boolean supportsPropertiesFile() {
        return false;
    }

    protected boolean supportsOutputFile() {
        return false;
    }

    protected boolean supportsDebugLogging() {
        return false;
    }

    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Nullable
    protected String getToolCompletionMessage() {
        return null;
    }

    @NotNull
    public final ArgumentParser createArgumentParser() throws ArgumentException {
        String version;
        ArgumentParser parser = new ArgumentParser(this.getToolName(), this.getToolDescription(), this.getAdditionalDescriptionParagraphs(), this.getMinTrailingArguments(), this.getMaxTrailingArguments(), this.getTrailingArgumentsPlaceholder());
        parser.setCommandLineTool(this);
        this.addToolArguments(parser);
        if (this.supportsInteractiveMode()) {
            this.interactiveArgument = new BooleanArgument(null, "interactive", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_INTERACTIVE.get());
            this.interactiveArgument.setUsageArgument(true);
            parser.addArgument(this.interactiveArgument);
        }
        if (this.supportsOutputFile()) {
            this.outputFileArgument = new FileArgument(null, "outputFile", false, 1, null, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_OUTPUT_FILE.get(), false, true, true, false);
            this.outputFileArgument.addLongIdentifier("output-file", true);
            this.outputFileArgument.setUsageArgument(true);
            parser.addArgument(this.outputFileArgument);
            this.appendToOutputFileArgument = new BooleanArgument(null, "appendToOutputFile", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_APPEND_TO_OUTPUT_FILE.get(this.outputFileArgument.getIdentifierString()));
            this.appendToOutputFileArgument.addLongIdentifier("append-to-output-file", true);
            this.appendToOutputFileArgument.setUsageArgument(true);
            parser.addArgument(this.appendToOutputFileArgument);
            this.teeOutputArgument = new BooleanArgument(null, "teeOutput", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_TEE_OUTPUT.get(this.outputFileArgument.getIdentifierString()));
            this.teeOutputArgument.addLongIdentifier("tee-output", true);
            this.teeOutputArgument.setUsageArgument(true);
            parser.addArgument(this.teeOutputArgument);
            parser.addDependentArgumentSet(this.appendToOutputFileArgument, this.outputFileArgument, new Argument[0]);
            parser.addDependentArgumentSet(this.teeOutputArgument, this.outputFileArgument, new Argument[0]);
        }
        this.helpArgument = new BooleanArgument(Character.valueOf('H'), "help", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP.get());
        this.helpArgument.addShortIdentifier(Character.valueOf('?'), true);
        this.helpArgument.setUsageArgument(true);
        parser.addArgument(this.helpArgument);
        if (!parser.getSubCommands().isEmpty()) {
            this.helpSubcommandsArgument = new BooleanArgument(null, "help-subcommands", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP_SUBCOMMANDS.get());
            this.helpSubcommandsArgument.addLongIdentifier("helpSubcommands", true);
            this.helpSubcommandsArgument.addLongIdentifier("help-subcommand", true);
            this.helpSubcommandsArgument.addLongIdentifier("helpSubcommand", true);
            this.helpSubcommandsArgument.setUsageArgument(true);
            parser.addArgument(this.helpSubcommandsArgument);
        }
        if (this.supportsDebugLogging()) {
            File logsToolsDir;
            this.helpDebugArgument = new BooleanArgument(null, "help-debug", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_HELP_DEBUG.get());
            this.helpDebugArgument.addLongIdentifier("helpDebug", true);
            this.helpDebugArgument.setUsageArgument(true);
            parser.addArgument(this.helpDebugArgument);
            this.enableDebugArgument = new BooleanArgument(null, "enable-debug-logging", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_ENABLE_DEBUG.get());
            this.enableDebugArgument.addLongIdentifier("enableDebugLogging", true);
            this.enableDebugArgument.addLongIdentifier("enable-debug-log", true);
            this.enableDebugArgument.addLongIdentifier("enableDebugLog", true);
            this.enableDebugArgument.addLongIdentifier("enable-debugging", true);
            this.enableDebugArgument.addLongIdentifier("enableDebugging", true);
            this.enableDebugArgument.addLongIdentifier("enable-debug", true);
            this.enableDebugArgument.addLongIdentifier("enableDebug", true);
            this.enableDebugArgument.setHidden(true);
            parser.addArgument(this.enableDebugArgument);
            this.debugLogLevelArgument = new StringArgument(null, "debug-log-level", false, 1, "{level}", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_DEBUG_LOG_LEVEL.get(), "severe");
            this.debugLogLevelArgument.addLongIdentifier("debugLogLevel", true);
            this.debugLogLevelArgument.addLongIdentifier("debug-level", true);
            this.debugLogLevelArgument.addLongIdentifier("debugLevel", true);
            this.debugLogLevelArgument.setHidden(true);
            parser.addArgument(this.debugLogLevelArgument);
            this.debugLogCategoryArgument = new StringArgument(null, "debug-log-category", false, 0, "{category}", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_DEBUG_LOG_CATEGORY.get());
            this.debugLogCategoryArgument.addLongIdentifier("debugLogCategory", true);
            this.debugLogCategoryArgument.addLongIdentifier("debug-category", true);
            this.debugLogCategoryArgument.addLongIdentifier("debugCategory", true);
            this.debugLogCategoryArgument.addLongIdentifier("debug-log-type", true);
            this.debugLogCategoryArgument.addLongIdentifier("debugLogType", true);
            this.debugLogCategoryArgument.addLongIdentifier("debug-type", true);
            this.debugLogCategoryArgument.addLongIdentifier("debugType", true);
            this.debugLogCategoryArgument.setHidden(true);
            parser.addArgument(this.debugLogCategoryArgument);
            this.includeDebugStackTracesArgument = new BooleanArgument(null, "include-debug-stack-traces", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_INCLUDE_DEBUG_STACK_TRACES.get());
            this.includeDebugStackTracesArgument.addLongIdentifier("includeDebugStackTraces", true);
            this.includeDebugStackTracesArgument.addLongIdentifier("include-debug-stack-trace", true);
            this.includeDebugStackTracesArgument.addLongIdentifier("includeDebugStackTrace", true);
            this.includeDebugStackTracesArgument.setHidden(true);
            parser.addArgument(this.includeDebugStackTracesArgument);
            this.useMultiLineDebugMessagesArgument = new BooleanArgument(null, "use-multi-line-debug-messages", 1, UtilityMessages.INFO_CL_TOOL_DESCRIPTION_USE_MULTI_LINE_DEBUG_MESSAGES.get());
            this.useMultiLineDebugMessagesArgument.addLongIdentifier("useMultiLineDebugMessages", true);
            this.useMultiLineDebugMessagesArgument.setHidden(true);
            parser.addArgument(this.useMultiLineDebugMessagesArgument);
            String debugLogFileBaseName = this.getToolName() + ".debug";
            File debugLogFile = new File(debugLogFileBaseName);
            String debugLogFilePath = debugLogFileBaseName;
            File serverRoot = InternalSDKHelper.getPingIdentityServerRoot();
            if (serverRoot != null && (logsToolsDir = StaticUtils.constructPath(serverRoot, "logs", "tools")).exists() && logsToolsDir.isDirectory()) {
                debugLogFile = new File(logsToolsDir, debugLogFileBaseName);
                debugLogFilePath = debugLogFile.getAbsolutePath();
            }
            this.debugLogFileArgument = new FileArgument(null, "debug-log-file", false, 1, "{path}", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_DEBUG_LOG_FILE.get(debugLogFilePath), false, true, true, false, Collections.singletonList(debugLogFile));
            this.debugLogFileArgument.addLongIdentifier("debugLogFile", true);
            this.debugLogFileArgument.addLongIdentifier("debug-log", true);
            this.debugLogFileArgument.addLongIdentifier("debugLog", true);
            this.debugLogFileArgument.addLongIdentifier("debug-file", true);
            this.debugLogFileArgument.addLongIdentifier("debugFile", true);
            this.debugLogFileArgument.setHidden(true);
            parser.addArgument(this.debugLogFileArgument);
        }
        if ((version = this.getToolVersion()) != null && !version.isEmpty() && parser.getNamedArgument("version") == null) {
            Character shortIdentifier = parser.getNamedArgument(Character.valueOf('V')) == null ? Character.valueOf('V') : null;
            this.versionArgument = new BooleanArgument(shortIdentifier, "version", UtilityMessages.INFO_CL_TOOL_DESCRIPTION_VERSION.get());
            this.versionArgument.setUsageArgument(true);
            parser.addArgument(this.versionArgument);
        }
        if (this.supportsPropertiesFile()) {
            parser.enablePropertiesFileSupport();
        }
        return parser;
    }

    void setHelpSASLArgument(@NotNull BooleanArgument helpSASLArgument) {
        this.helpSASLArgument = helpSASLArgument;
    }

    protected void addEnableSSLDebuggingArgument(@NotNull BooleanArgument enableSSLDebuggingArgument) {
        this.enableSSLDebuggingArguments.add(enableSSLDebuggingArgument);
    }

    @NotNull
    static Set<String> getUsageArgumentIdentifiers(@NotNull CommandLineTool tool) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(9));
        ids.add("help");
        ids.add("version");
        ids.add("helpSubcommands");
        if (tool.supportsInteractiveMode()) {
            ids.add("interactive");
        }
        if (tool.supportsPropertiesFile()) {
            ids.add("propertiesFilePath");
            ids.add("generatePropertiesFile");
            ids.add("noPropertiesFile");
            ids.add("suppressPropertiesFileComment");
        }
        if (tool.supportsOutputFile()) {
            ids.add("outputFile");
            ids.add("appendToOutputFile");
            ids.add("teeOutput");
        }
        return Collections.unmodifiableSet(ids);
    }

    public abstract void addToolArguments(@NotNull ArgumentParser var1) throws ArgumentException;

    public void doExtendedArgumentValidation() throws ArgumentException {
    }

    @NotNull
    public abstract ResultCode doToolProcessing();

    protected boolean registerShutdownHook() {
        return false;
    }

    protected void doShutdownHookProcessing(@Nullable ResultCode resultCode) {
        throw new LDAPSDKUsageException(UtilityMessages.ERR_COMMAND_LINE_TOOL_SHUTDOWN_HOOK_NOT_IMPLEMENTED.get(this.getToolName()));
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @Nullable
    public LinkedHashMap<String[], String> getExampleUsages() {
        return null;
    }

    @NotNull
    public final PasswordFileReader getPasswordFileReader() {
        return this.passwordFileReader;
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    @NotNull
    public final PrintStream getOriginalOut() {
        return this.originalOut;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void out(Object ... msg) {
        CommandLineTool.write(this.out, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapOut(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.out, indent, wrapColumn, msg);
    }

    final synchronized void wrapStandardOut(int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        CommandLineTool.write(this.out, firstLineIndent, subsequentLineIndent, wrapColumn, endWithNewline, msg);
    }

    @NotNull
    public final PrintStream getErr() {
        return this.err;
    }

    @NotNull
    public final PrintStream getOriginalErr() {
        return this.originalErr;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void err(Object ... msg) {
        CommandLineTool.write(this.err, 0, 0, msg);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final synchronized void wrapErr(int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(this.err, indent, wrapColumn, msg);
    }

    private static void write(@NotNull PrintStream stream, int indent, int wrapColumn, Object ... msg) {
        CommandLineTool.write(stream, indent, indent, wrapColumn, true, msg);
    }

    private static void write(@NotNull PrintStream stream, int firstLineIndent, int subsequentLineIndent, int wrapColumn, boolean endWithNewline, Object ... msg) {
        StringBuilder buffer = new StringBuilder();
        for (Object o : msg) {
            buffer.append(o);
        }
        if (wrapColumn > 2) {
            boolean firstLine = true;
            for (String line : StaticUtils.wrapLine(buffer.toString(), wrapColumn - firstLineIndent, wrapColumn - subsequentLineIndent)) {
                int indent;
                if (firstLine) {
                    indent = firstLineIndent;
                    firstLine = false;
                } else {
                    stream.println();
                    indent = subsequentLineIndent;
                }
                if (indent > 0) {
                    for (int i = 0; i < indent; ++i) {
                        stream.print(' ');
                    }
                }
                stream.print(line);
            }
        } else {
            if (firstLineIndent > 0) {
                for (int i = 0; i < firstLineIndent; ++i) {
                    stream.print(' ');
                }
            }
            stream.print(buffer.toString());
        }
        if (endWithNewline) {
            stream.println();
        }
        stream.flush();
    }

    private void printDebugHelp() {
        this.wrapOut(0, WRAP_COLUMN, UtilityMessages.INFO_CL_TOOL_DEBUG_USAGE_SUMMARY.get());
        this.out(new Object[0]);
        this.printDebugArgHelp(this.enableDebugArgument);
        this.printDebugArgHelp(this.debugLogLevelArgument);
        this.printDebugArgHelp(this.debugLogCategoryArgument);
        this.printDebugArgHelp(this.includeDebugStackTracesArgument);
        this.printDebugArgHelp(this.useMultiLineDebugMessagesArgument);
        this.printDebugArgHelp(this.debugLogFileArgument);
    }

    private void printDebugArgHelp(@NotNull Argument argument) {
        this.out("    " + argument.getIdentifierString());
        int descriptionWrapColumn = WRAP_COLUMN - 8;
        for (String line : StaticUtils.wrapLine(argument.getDescription(), descriptionWrapColumn)) {
            this.out("        " + line);
        }
    }

    private void enableDebugLogging() throws LDAPException {
        Level debugLogLevel;
        String debugLevelString = this.debugLogLevelArgument.getValue();
        try {
            debugLogLevel = Debug.parseDebugLogLevel(debugLevelString);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_CL_TOOL_CANNOT_PARSE_DEBUG_LOG_LEVEL.get(debugLevelString));
        }
        EnumSet<DebugType> debugTypes = EnumSet.allOf(DebugType.class);
        if (this.debugLogCategoryArgument.isPresent()) {
            debugTypes.clear();
            for (String categoryName : this.debugLogCategoryArgument.getValues()) {
                DebugType category = DebugType.forName(categoryName);
                if (category == null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_CL_TOOL_CANNOT_PARSE_DEBUG_LOG_CATEGORY.get(categoryName));
                }
                debugTypes.add(category);
            }
        }
        Debug.setEnabled(true, debugTypes);
        if (this.includeDebugStackTracesArgument.isPresent()) {
            Debug.setIncludeStackTrace(true);
        }
        if (this.useMultiLineDebugMessagesArgument.isPresent()) {
            Debug.setUseMultiLineDebugMessages(true);
        }
        String debugLogFilePath = this.debugLogFileArgument.getValue().getAbsolutePath();
        try {
            FileHandler logFileHandler = new FileHandler(debugLogFilePath);
            logFileHandler.setFormatter(new MinimalLogFormatter(null, false, false, true));
            Logger logger = Debug.getLogger();
            StaticUtils.setLoggerLevel(logger, debugLogLevel);
            logger.setUseParentHandlers(false);
            logger.addHandler(logFileHandler);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_CL_TOOL_CANNOT_CREATE_DEBUG_FILE_HANDLER.get(debugLogFilePath, StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

