/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.lang.ref.SoftReference;
import java.util.BitSet;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.io.MaxHeaderLengthLimitException;
import org.apache.james.mime4j.stream.FieldBuilder;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.BufferRecycler;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.RecycledByteArrayBuffer;

public class DefaultFieldBuilder
implements FieldBuilder {
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef;
    private static final BitSet FIELD_CHARS;
    private final RecycledByteArrayBuffer buf = new RecycledByteArrayBuffer(DefaultFieldBuilder.getBufferRecycler(), 4096);
    private final int maxlen;

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            ref = new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref);
        }
        return br;
    }

    public DefaultFieldBuilder(int maxlen) {
        this.maxlen = maxlen;
    }

    @Override
    public void reset() {
        this.buf.clear();
    }

    @Override
    public void append(ByteArrayBuffer line) throws MaxHeaderLengthLimitException {
        if (line == null) {
            return;
        }
        int len = line.length();
        if (this.maxlen > 0 && this.buf.length() + len >= this.maxlen) {
            throw new MaxHeaderLengthLimitException("Maximum header length limit (" + this.maxlen + ") exceeded");
        }
        this.buf.append(line.buffer(), 0, line.length());
    }

    @Override
    public RawField build() throws MimeException {
        int len = this.buf.length();
        if (len > 0) {
            if (this.buf.byteAt(len - 1) == 10) {
                --len;
            }
            if (this.buf.byteAt(len - 1) == 13) {
                --len;
            }
        }
        ByteArrayBuffer copy = new ByteArrayBuffer(this.buf.buffer(), len, false);
        RawField field2 = RawFieldParser.DEFAULT.parseField(copy);
        String name = field2.getName();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (FIELD_CHARS.get(ch)) continue;
            throw new MimeException("MIME field name contains illegal characters: " + field2.getName());
        }
        return field2;
    }

    @Override
    public RecycledByteArrayBuffer getRaw() {
        return this.buf;
    }

    @Override
    public void release() {
        this.buf.release();
    }

    static {
        int i;
        _recyclerRef = new ThreadLocal();
        FIELD_CHARS = new BitSet();
        for (i = 33; i <= 57; ++i) {
            FIELD_CHARS.set(i);
        }
        for (i = 59; i <= 126; ++i) {
            FIELD_CHARS.set(i);
        }
    }
}

