/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;

public class TaskMetaManager
extends AbstractMetaManager {
    private static final String TASK_STATUS_POSTFIX = "Status";
    private static final String TASK_PROGRESS_POSTFIX = "Progress";
    private static final String TASK_CONTEXT_POSTFIX = "Context";
    private static final String TASK_RETRY_POSTFIX = "Retry";

    public TaskMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    public LockResult tryLockTask(String graphSpace, String graphName, String taskId) {
        String key = this.taskLockKey(graphSpace, graphName, taskId);
        return this.tryLock(key);
    }

    public boolean isLockedTask(String graphSpace, String graphName, String taskId) {
        String key = this.taskLockKey(graphSpace, graphName, taskId);
        return this.metaDriver.isLocked(key);
    }

    public void unlockTask(String graphSpace, String graphName, String taskId, LockResult lockResult) {
        String key = this.taskLockKey(graphSpace, graphName, taskId);
        this.unlock(key, lockResult);
    }

    private String taskLockKey(String graphSpace, String graphName, String taskId) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graphName, "TASK", taskId, "TASK_LOCK");
    }
}

