/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.rank;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class PageRankAlgorithm
extends AbstractCommAlgorithm {
    protected static final Logger LOG = Log.logger(PageRankAlgorithm.class);

    @Override
    public String name() {
        return "page_rank";
    }

    @Override
    public String category() {
        return "rank";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        PageRankAlgorithm.alpha(parameters);
        PageRankAlgorithm.times(parameters);
        PageRankAlgorithm.precision(parameters);
        PageRankAlgorithm.degree(parameters);
        PageRankAlgorithm.directionOutIn(parameters);
        PageRankAlgorithm.top(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        Object object;
        Traverser traverser = new Traverser(job);
        try {
            object = traverser.pageRank(PageRankAlgorithm.alpha(parameters), PageRankAlgorithm.times(parameters), PageRankAlgorithm.precision(parameters), PageRankAlgorithm.degree(parameters), PageRankAlgorithm.directionOutIn(parameters), PageRankAlgorithm.top(parameters));
        }
        catch (Throwable throwable) {
            try {
                try {
                    traverser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                job.graph().tx().rollback();
                throw e;
            }
        }
        traverser.close();
        return object;
    }

    public static class DoublePair
    implements Comparable<DoublePair> {
        private double left;
        private double right;

        private DoublePair(double left, double right) {
            this.left = left;
            this.right = right;
        }

        public void addLeft(double value) {
            this.left += value;
        }

        public void addRight(double value) {
            this.right += value;
        }

        public double left() {
            return this.left;
        }

        public void left(double value) {
            this.left = value;
        }

        public double right() {
            return this.right;
        }

        public void right(double value) {
            this.right = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("left:").append(this.left).append(", right: ").append(this.right);
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DoublePair)) {
                return false;
            }
            DoublePair other = (DoublePair)obj;
            return this.left == other.left && this.right == other.right;
        }

        public int hashCode() {
            return Double.hashCode(this.left) ^ Double.hashCode(this.right);
        }

        @Override
        public int compareTo(DoublePair o) {
            double result = this.left - o.left;
            if (result > 0.0) {
                return 1;
            }
            if (result < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        private final Map<Id, DoublePair> vertexRankMap = new HashMap<Id, DoublePair>();

        public Traverser(UserJob<Object> job) {
            super(job);
        }

        private Object pageRank(double alpha, int maxTimes, double precision, long degree, Directions direction, long topN) {
            int times;
            this.initSchema();
            double changedRank = 0.0;
            long numOfVertices = this.initRankMap();
            for (times = 0; times < maxTimes; ++times) {
                Id currentSourceVertexId = null;
                Iterator<Edge> edges = this.edges(direction);
                ArrayList<Id> adjacentVertices = new ArrayList<Id>();
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id sourceVertexId = edge.ownerVertex().id();
                    Id targetVertexId = edge.otherVertex().id();
                    if (currentSourceVertexId == null) {
                        currentSourceVertexId = sourceVertexId;
                        adjacentVertices.add(targetVertexId);
                        continue;
                    }
                    if (currentSourceVertexId.equals(sourceVertexId)) {
                        if ((long)adjacentVertices.size() >= degree) continue;
                        adjacentVertices.add(targetVertexId);
                        continue;
                    }
                    this.contributeToAdjacentVertices(currentSourceVertexId, adjacentVertices);
                    adjacentVertices = new ArrayList();
                    currentSourceVertexId = sourceVertexId;
                    adjacentVertices.add(targetVertexId);
                }
                this.contributeToAdjacentVertices(currentSourceVertexId, adjacentVertices);
                double sumRank = this.computeRank(alpha, numOfVertices);
                double compensatedRank = 1.0 - sumRank;
                changedRank = this.compensateRank(compensatedRank / (double)numOfVertices);
                LOG.debug("PageRank execution times:{}, changedRank:{} ", (Object)times, (Object)changedRank);
                if (changedRank < precision) break;
            }
            this.writeBackRankValues();
            if (topN > 0L) {
                Object topNJson = this.getTopRank(topN);
                return ImmutableMap.of((Object)"alpha", (Object)alpha, (Object)"iteration_times", (Object)times, (Object)"last_changed_rank", (Object)changedRank, (Object)"times", (Object)maxTimes, (Object)"top", (Object)topNJson);
            }
            return ImmutableMap.of((Object)"alpha", (Object)alpha, (Object)"iteration_times", (Object)times, (Object)"last_changed_rank", (Object)changedRank, (Object)"times", (Object)maxTimes);
        }

        private Object getTopRank(long topN) {
            AbstractAlgorithm.JsonMap jsonMap = new AbstractAlgorithm.JsonMap();
            jsonMap.startObject();
            Map<Id, DoublePair> topNMap = HugeTraverser.topN(this.vertexRankMap, true, topN);
            for (Map.Entry<Id, DoublePair> e : topNMap.entrySet()) {
                jsonMap.append(e.getKey().toString(), (Number)e.getValue().left);
            }
            jsonMap.endObject();
            return jsonMap.asJson();
        }

        private long initRankMap() {
            long vertexCount = 0L;
            Iterator<Vertex> vertices = this.vertices();
            while (vertices.hasNext()) {
                Id vertex = ((HugeVertex)vertices.next()).id();
                DoublePair pair = new DoublePair(0.0, 0.0);
                this.vertexRankMap.put(vertex, pair);
                ++vertexCount;
            }
            double initValue = 1.0 / (double)vertexCount;
            for (DoublePair pair : this.vertexRankMap.values()) {
                pair.left(initValue);
            }
            return vertexCount;
        }

        private void contributeToAdjacentVertices(Id sourceVertexId, List<Id> adjacentVertices) {
            if (adjacentVertices.isEmpty()) {
                return;
            }
            DoublePair sourcePair = this.vertexRankMap.get(sourceVertexId);
            if (sourcePair == null) {
                LOG.info("source vertex {} not exists.", (Object)sourceVertexId);
                return;
            }
            double distributedValue = sourcePair.left() / (double)adjacentVertices.size();
            for (Id targetId : adjacentVertices) {
                DoublePair targetPair = this.vertexRankMap.get(targetId);
                if (targetPair == null) {
                    LOG.warn("target vertex {} not exists.", (Object)targetId);
                    continue;
                }
                targetPair.addRight(distributedValue);
            }
        }

        private double compensateRank(double compensatedRank) {
            double changedRank = 0.0;
            for (DoublePair pair : this.vertexRankMap.values()) {
                double previousRank = pair.left();
                double currentRank = pair.right() + compensatedRank;
                changedRank += Math.abs(previousRank - currentRank);
                pair.left(currentRank);
                pair.right(0.0);
            }
            return changedRank;
        }

        private void initSchema() {
            SchemaManager schema = this.graph().schema();
            schema.propertyKey("r_rank").asDouble().ifNotExist().create();
            for (VertexLabel vl : schema.getVertexLabels()) {
                schema.vertexLabel(vl.name()).properties("r_rank").nullableKeys("r_rank").append();
            }
        }

        private void writeBackRankValues() {
            for (Map.Entry<Id, DoublePair> e : this.vertexRankMap.entrySet()) {
                Id vertexId = e.getKey();
                Vertex vertex = this.vertex(vertexId);
                if (vertex == null) continue;
                vertex.property("r_rank", (Object)e.getValue().left());
                this.commitIfNeeded();
            }
            this.graph().tx().commit();
        }

        private double computeRank(double alpha, long numOfVertices) {
            double oneMinusAlpha = 1.0 - alpha;
            double sum = 0.0;
            double baseRank = alpha / (double)numOfVertices;
            for (DoublePair pair : this.vertexRankMap.values()) {
                double rankValue = baseRank + pair.right() * oneMinusAlpha;
                pair.right(rankValue);
                sum += rankValue;
            }
            return sum;
        }
    }
}

