/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.ConditionQueryFlatten;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.MetaDispatcher;
import org.apache.hugegraph.backend.store.MetaHandler;
import org.apache.hugegraph.backend.store.SystemSchemaStore;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;

public abstract class AbstractBackendStore<Session extends BackendSession>
implements BackendStore {
    private final SystemSchemaStore systemSchemaStore = new SystemSchemaStore();
    private final MetaDispatcher<Session> dispatcher = new MetaDispatcher();

    protected MetaDispatcher<Session> metaDispatcher() {
        return this.dispatcher;
    }

    protected List<HugeType> getHugeTypes(Query sampleQuery) {
        HashSet<HugeType> typeSet = new HashSet<HugeType>();
        for (Condition c : sampleQuery.conditions()) {
            if (c.isRelation() && c.isSysprop()) {
                Condition.SyspropRelation sr = (Condition.SyspropRelation)c;
                if (sr.relation() != Condition.RelationType.EQ || !sr.key().equals((Object)HugeKeys.DIRECTION)) continue;
                typeSet.add(((Directions)sr.value()).type());
                continue;
            }
            if (c.type() != Condition.ConditionType.OR || !c.isSysprop()) continue;
            for (Condition.Relation relation : c.relations()) {
                if (relation.relation() != Condition.RelationType.EQ || !relation.key().equals((Object)HugeKeys.DIRECTION)) continue;
                typeSet.add(((Directions)relation.value()).type());
            }
        }
        return new ArrayList<HugeType>(typeSet);
    }

    @Override
    public Iterator<Iterator<BackendEntry>> query(Iterator<Query> queries, Function<Query, Query> queryWriter, HugeGraph hugeGraph) {
        ArrayList<FlatMapperIterator> result = new ArrayList<FlatMapperIterator>();
        FlatMapperIterator it = new FlatMapperIterator(queries, query -> {
            assert (query instanceof ConditionQuery);
            List<ConditionQuery> flattenQueryList = ConditionQueryFlatten.flatten((ConditionQuery)query);
            if (flattenQueryList.size() > 1) {
                ExtendableIterator itExtend = new ExtendableIterator();
                flattenQueryList.forEach(cq -> {
                    Query cQuery = (Query)queryWriter.apply((Query)cq);
                    itExtend.extend(this.query(cQuery));
                });
                return itExtend;
            }
            return this.query((Query)queryWriter.apply((Query)query));
        });
        result.add(it);
        return result.iterator();
    }

    public void registerMetaHandler(String name, MetaHandler<Session> handler) {
        this.dispatcher.registerMetaHandler(name, handler);
    }

    @Override
    public String storedVersion() {
        throw new UnsupportedOperationException("AbstractBackendStore.storedVersion()");
    }

    @Override
    public SystemSchemaStore systemSchemaStore() {
        return this.systemSchemaStore;
    }

    @Override
    public <R> R metadata(HugeType type, String meta, Object[] args) {
        MetaDispatcher<Session> dispatcher;
        Session session = this.session(type);
        if (type == null) {
            dispatcher = this.metaDispatcher();
        } else {
            BackendTable<Session, ?> table = this.table(type);
            dispatcher = table.metaDispatcher();
        }
        return dispatcher.dispatchMetaHandler(session, meta, args);
    }

    protected void checkOpened() throws ConnectionException {
        if (!this.opened()) {
            throw new ConnectionException("The '%s' store of %s has not been opened", this.database(), this.provider().type());
        }
    }

    public String toString() {
        return String.format("%s/%s", this.database(), this.store());
    }

    protected abstract BackendTable<Session, ?> table(HugeType var1);

    protected static HugeType convertTaskOrServerToVertex(HugeType type) {
        if (HugeType.TASK.equals(type) || HugeType.SERVER.equals(type)) {
            return HugeType.VERTEX;
        }
        return type;
    }

    protected abstract Session session(HugeType var1);
}

