/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationQueuesClientZKImpl
extends ReplicationStateZKBase
implements ReplicationQueuesClient {
    Logger LOG = LoggerFactory.getLogger(ReplicationQueuesClientZKImpl.class);

    public ReplicationQueuesClientZKImpl(ReplicationQueuesClientArguments args) {
        this(args.getZk(), args.getConf(), args.getAbortable());
    }

    public ReplicationQueuesClientZKImpl(ZKWatcher zk, Configuration conf, Abortable abortable) {
        super(zk, conf, abortable);
    }

    @Override
    public void init() throws ReplicationException {
        try {
            if (ZKUtil.checkExists(this.zookeeper, this.queuesZNode) < 0) {
                ZKUtil.createWithParents(this.zookeeper, this.queuesZNode);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Internal error while initializing a queues client", e);
        }
    }

    @Override
    public List<String> getListOfReplicators() throws KeeperException {
        return super.getListOfReplicatorsZK();
    }

    @Override
    public List<String> getLogsInQueue(String serverName, String queueId) throws KeeperException {
        String znode = ZNodePaths.joinZNode(this.queuesZNode, serverName);
        znode = ZNodePaths.joinZNode(znode, queueId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of wals for queueId=" + queueId + " and serverName=" + serverName, e);
            throw e;
        }
        return result;
    }

    @Override
    public List<String> getAllQueues(String serverName) throws KeeperException {
        String znode = ZNodePaths.joinZNode(this.queuesZNode, serverName);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of queues for serverName=" + serverName, e);
            throw e;
        }
        return result;
    }

    @Override
    public Set<String> getAllWALs() throws KeeperException {
        int retry = 0;
        while (true) {
            int v0 = this.getQueuesZNodeCversion();
            List<String> rss = this.getListOfReplicators();
            if (rss == null || rss.isEmpty()) {
                this.LOG.debug("Didn't find any region server that replicates, won't prevent any deletions.");
                return ImmutableSet.of();
            }
            HashSet<String> wals = Sets.newHashSet();
            for (String rs : rss) {
                List<String> listOfPeers = this.getAllQueues(rs);
                if (listOfPeers == null) continue;
                for (String id : listOfPeers) {
                    List<String> peersWals = this.getLogsInQueue(rs, id);
                    if (peersWals == null) continue;
                    wals.addAll(peersWals);
                }
            }
            int v1 = this.getQueuesZNodeCversion();
            if (v0 == v1) {
                return wals;
            }
            this.LOG.info(String.format("Replication queue node cversion changed from %d to %d, retry = %d", v0, v1, retry));
            ++retry;
        }
    }

    public int getQueuesZNodeCversion() throws KeeperException {
        try {
            Stat stat = new Stat();
            ZKUtil.getDataNoWatch(this.zookeeper, this.queuesZNode, stat);
            return stat.getCversion();
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get stat of replication rs node", e);
            throw e;
        }
    }

    @Override
    public int getHFileRefsNodeChangeVersion() throws KeeperException {
        Stat stat = new Stat();
        try {
            ZKUtil.getDataNoWatch(this.zookeeper, this.hfileRefsZNode, stat);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get stat of replication hfile references node.", e);
            throw e;
        }
        return stat.getCversion();
    }

    @Override
    public List<String> getAllPeersFromHFileRefsQueue() throws KeeperException {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, this.hfileRefsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of all peers in hfile references node.", e);
            throw e;
        }
        return result;
    }

    @Override
    public List<String> getReplicableHFiles(String peerId) throws KeeperException {
        String znode = ZNodePaths.joinZNode(this.hfileRefsZNode, peerId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of hfile references for peerId=" + peerId, e);
            throw e;
        }
        return result;
    }
}

