/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.Discoverable;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.discovery.DiscoveryServiceGrpc;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.grpc.discovery.RegisterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryClient
implements Closeable,
Discoverable {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClient.class);
    private Timer timer = new Timer("serverHeartbeat", true);
    private volatile AtomicBoolean requireResetStub = new AtomicBoolean(false);
    protected int period;
    LinkedList<String> pdAddresses = new LinkedList();
    ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile int currentIndex;
    private int maxTime = 6;
    private ManagedChannel channel = null;
    private DiscoveryServiceGrpc.DiscoveryServiceBlockingStub registerStub;
    private DiscoveryServiceGrpc.DiscoveryServiceBlockingStub blockingStub;
    private PDConfig config = PDConfig.of();
    private long registerTimeout = 30000L;

    public DiscoveryClient(String centerAddress, int delay, PDConfig conf) {
        String[] addresses = centerAddress.split(",");
        for (int i = 0; i < addresses.length; ++i) {
            String singleAddress = addresses[i];
            if (singleAddress == null || singleAddress.length() <= 0) continue;
            this.pdAddresses.add(addresses[i]);
        }
        this.period = delay;
        if (this.period > 60000) {
            this.registerTimeout = this.period / 2;
        }
        if (this.maxTime < addresses.length) {
            this.maxTime = addresses.length;
        }
        if (conf != null) {
            this.config = conf;
        }
    }

    private <V, R> R tryWithTimes(Function<V, R> function, V v) {
        Exception ex = null;
        if (this.registerStub == null || this.blockingStub == null) {
            this.requireResetStub.set(true);
            this.resetStub();
        }
        for (int i = 0; i < this.maxTime; ++i) {
            try {
                R r = function.apply(v);
                return r;
            }
            catch (Exception e) {
                this.requireResetStub.set(true);
                this.resetStub();
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            log.error("try discovery method with error: ", ex);
        }
        return null;
    }

    private void resetStub() {
        String errLog = null;
        for (int i = this.currentIndex + 1; i <= this.pdAddresses.size() + this.currentIndex; ++i) {
            this.currentIndex = i % this.pdAddresses.size();
            String singleAddress = this.pdAddresses.get(this.currentIndex);
            try {
                if (this.requireResetStub.get()) {
                    this.resetChannel(singleAddress);
                }
                errLog = null;
                break;
            }
            catch (Exception e) {
                this.requireResetStub.set(true);
                if (errLog != null) continue;
                errLog = e.getMessage();
                continue;
            }
        }
        if (errLog != null) {
            log.error(errLog);
        }
    }

    private void resetChannel(String singleAddress) throws PDException {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.requireResetStub.get()) {
                while (this.channel != null && !this.channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
                this.channel = ManagedChannelBuilder.forTarget((String)singleAddress).usePlaintext().build();
                this.registerStub = AbstractClient.setAsyncParams(DiscoveryServiceGrpc.newBlockingStub((Channel)this.channel), this.config);
                this.blockingStub = AbstractClient.setAsyncParams(DiscoveryServiceGrpc.newBlockingStub((Channel)this.channel), this.config);
                this.requireResetStub.set(false);
            }
        }
        catch (Exception e) {
            throw new PDException(-1, String.format("Reset channel with error : %s.", e.getMessage()));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public NodeInfos getNodeInfos(Query query) {
        return this.tryWithTimes(q -> {
            NodeInfos nodes;
            this.readWriteLock.readLock().lock();
            try {
                nodes = ((DiscoveryServiceGrpc.DiscoveryServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.config.getGrpcTimeOut(), TimeUnit.MILLISECONDS)).getNodes(q);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            return nodes;
        }, query);
    }

    @Override
    public void scheduleTask() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                NodeInfo nodeInfo = DiscoveryClient.this.getRegisterNode();
                DiscoveryClient.this.tryWithTimes(t -> {
                    RegisterInfo register = null;
                    DiscoveryClient.this.readWriteLock.readLock().lock();
                    try {
                        register = ((DiscoveryServiceGrpc.DiscoveryServiceBlockingStub)DiscoveryClient.this.registerStub.withDeadlineAfter(DiscoveryClient.this.registerTimeout, TimeUnit.MILLISECONDS)).register(t);
                        Consumer<RegisterInfo> consumer = DiscoveryClient.this.getRegisterConsumer();
                        if (consumer != null) {
                            try {
                                consumer.accept(register);
                            }
                            catch (Exception e) {
                                log.warn("run consumer when heartbeat with error:", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        DiscoveryClient.this.readWriteLock.readLock().unlock();
                    }
                    return register;
                }, nodeInfo);
            }
        }, 0L, (long)this.period);
    }

    abstract NodeInfo getRegisterNode();

    abstract Consumer<RegisterInfo> getRegisterConsumer();

    @Override
    public void cancelTask() {
        this.timer.cancel();
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.readWriteLock.writeLock().lock();
        try {
            while (this.channel != null && !this.channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (Exception e) {
            log.info("Close channel with error : {}.", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

