/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter.sofatracer;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.module.SofaTracerModule;

@Extension(value="providerTracer", order=-10000)
@AutoActive(providerSide=true)
public class ProviderTracerFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return SofaTracerModule.isEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        SofaTracerSpan serverSpan = null;
        try {
            SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
            serverSpan = sofaTraceContext.getCurrentSpan();
            if (serverSpan != null) {
                RpcInternalContext context = RpcInternalContext.getContext();
                serverSpan.setTag("service", request.getTargetServiceUniqueName());
                serverSpan.setTag("method", request.getMethodName());
                serverSpan.setTag("remote.ip", context.getRemoteHostName());
                serverSpan.setTag("remote.app", (String)request.getRequestProp("app"));
                serverSpan.setTag("protocol", (String)request.getRequestProp("protocol"));
                serverSpan.setTag("invoke.type", (String)request.getRequestProp("type"));
                ProviderConfig providerConfig = (ProviderConfig)invoker.getConfig();
                serverSpan.setTag("local.app", providerConfig.getAppName());
                serverSpan.setTag("server.pool.wait.time", (Number)context.getAttachment("_process_wait_time"));
            }
            SofaResponse sofaResponse = invoker.invoke(request);
            return sofaResponse;
        }
        finally {
            if (serverSpan != null) {
                serverSpan.setTag("biz.impl.time", (Number)RpcInternalContext.getContext().getAttachment("_impl_elapse"));
            }
        }
    }
}

