/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.opencypher.gremlin.extension.CypherBindingType;
import org.opencypher.gremlin.extension.CypherProcedureSignature;
import org.opencypher.gremlin.extension.CypherProcedures$;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.EmptyParserContext$;
import org.opencypher.gremlin.translation.EmptyPlannerName$;
import org.opencypher.gremlin.translation.Normalization$;
import org.opencypher.gremlin.translation.preparser.CypherPreParser$;
import org.opencypher.gremlin.translation.preparser.PreParsedStatement;
import org.opencypher.gremlin.translation.preparser.PreParserOption;
import org.opencypher.v9_0.ast.AliasedReturnItem;
import org.opencypher.v9_0.ast.Clause;
import org.opencypher.v9_0.ast.Query;
import org.opencypher.v9_0.ast.QueryPart;
import org.opencypher.v9_0.ast.Return;
import org.opencypher.v9_0.ast.ReturnItem;
import org.opencypher.v9_0.ast.ReturnItemsDef;
import org.opencypher.v9_0.ast.SingleQuery;
import org.opencypher.v9_0.ast.Statement;
import org.opencypher.v9_0.ast.Union;
import org.opencypher.v9_0.ast.UnresolvedCall;
import org.opencypher.v9_0.ast.semantics.SemanticFeature;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.LogicalVariable;
import org.opencypher.v9_0.expressions.Namespace;
import org.opencypher.v9_0.expressions.ProcedureName;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.frontend.PlannerName;
import org.opencypher.v9_0.frontend.phases.BaseContext;
import org.opencypher.v9_0.frontend.phases.BaseState;
import org.opencypher.v9_0.frontend.phases.CompilationPhases$;
import org.opencypher.v9_0.frontend.phases.InitialState;
import org.opencypher.v9_0.frontend.phases.InitialState$;
import org.opencypher.v9_0.frontend.phases.SemanticAnalysis;
import org.opencypher.v9_0.frontend.phases.Transformer;
import org.opencypher.v9_0.frontend.phases.isolateAggregation$;
import org.opencypher.v9_0.rewriting.RewriterStepSequencer$;
import org.opencypher.v9_0.rewriting.rewriters.LiteralExtraction;
import org.opencypher.v9_0.rewriting.rewriters.Never$;
import org.opencypher.v9_0.util.CypherException;
import org.opencypher.v9_0.util.InputPosition;
import org.opencypher.v9_0.util.symbols.AnyType;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.TypeRange;
import org.opencypher.v9_0.util.symbols.TypeSpec;
import org.opencypher.v9_0.util.symbols.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class CypherAst$ {
    public static CypherAst$ MODULE$;

    static {
        new CypherAst$();
    }

    public CypherAst parse(String queryText) throws CypherException {
        return this.parse(queryText, Collections.emptyMap(), Collections.emptyMap());
    }

    public CypherAst parse(String queryText, Map<String, ?> parameters) throws CypherException {
        return this.parse(queryText, parameters, Collections.emptyMap());
    }

    public CypherAst parse(String queryText, Map<String, ?> parameters, Map<String, CypherProcedureSignature> procedures) throws CypherException {
        scala.collection.immutable.Map scalaParameters = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(parameters).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map scalaProcedures = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(procedures).asScala()).toMap(Predef$.MODULE$.$conforms());
        return this.parse(queryText, (scala.collection.immutable.Map<String, Object>)scalaParameters, (scala.collection.immutable.Map<String, CypherProcedureSignature>)scalaProcedures);
    }

    private CypherAst parse(String queryText, scala.collection.immutable.Map<String, Object> parameters, scala.collection.immutable.Map<String, CypherProcedureSignature> procedures) throws CypherException {
        PreParsedStatement preParsedStatement = CypherPreParser$.MODULE$.apply(queryText);
        if (preParsedStatement == null) {
            throw new MatchError((Object)preParsedStatement);
        }
        String preParsedQueryText = preParsedStatement.statement();
        Seq<PreParserOption> options = preParsedStatement.options();
        InputPosition offset = preParsedStatement.offset();
        Tuple3 tuple3 = new Tuple3((Object)preParsedQueryText, options, (Object)offset);
        Tuple3 tuple32 = tuple3;
        String preParsedQueryText2 = (String)tuple32._1();
        Seq options2 = (Seq)tuple32._2();
        InputPosition offset2 = (InputPosition)tuple32._3();
        InitialState startState = new InitialState(preParsedQueryText2, (Option)new Some((Object)offset2), (PlannerName)EmptyPlannerName$.MODULE$, InitialState$.MODULE$.apply$default$4(), InitialState$.MODULE$.apply$default$5(), InitialState$.MODULE$.apply$default$6(), InitialState$.MODULE$.apply$default$7(), InitialState$.MODULE$.apply$default$8(), InitialState$.MODULE$.apply$default$9());
        BaseState state = (BaseState)CompilationPhases$.MODULE$.parsing((Function1 & Serializable & scala.Serializable)sequenceName -> RewriterStepSequencer$.MODULE$.newPlain(sequenceName), (LiteralExtraction)Never$.MODULE$, CompilationPhases$.MODULE$.parsing$default$3()).andThen((Transformer)isolateAggregation$.MODULE$).andThen((Transformer)new SemanticAnalysis(false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticFeature[0]))).andThen((Transformer)Normalization$.MODULE$).transform((Object)startState, (BaseContext)EmptyParserContext$.MODULE$.apply(preParsedQueryText2, (Option<InputPosition>)new Some((Object)offset2)));
        Statement statement = state.statement();
        scala.collection.immutable.Map<Expression, CypherType> expressionTypes = this.getExpressionTypes(state);
        scala.collection.immutable.Map<String, CypherType> returnTypes = this.getReturnTypes(expressionTypes, statement, procedures);
        return new CypherAst(statement, parameters, expressionTypes, returnTypes, (Seq<PreParserOption>)options2);
    }

    private scala.collection.immutable.Map<Expression, CypherType> getExpressionTypes(BaseState state) {
        return state.semantics().typeTable().mapValues((Function1 & Serializable & scala.Serializable)typeInfo -> {
            AnyType anyType;
            TypeSpec typeSpec = typeInfo.specified();
            if (typeSpec.ranges().lengthCompare(1) == 0) {
                void var2_2;
                CypherType typ = ((TypeRange)typeSpec.ranges().head()).lower();
                anyType = var2_2;
            } else {
                anyType = package$.MODULE$.CTAny();
            }
            return anyType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Map<String, CypherType> getReturnTypes(scala.collection.immutable.Map<Expression, CypherType> expressionTypes, Statement statement, scala.collection.immutable.Map<String, CypherProcedureSignature> procedures) {
        Seq seq;
        Seq seq2;
        Statement statement2 = statement;
        if (!(statement2 instanceof Query)) throw new MatchError((Object)statement2);
        Query query = (Query)statement2;
        QueryPart part = query.part();
        QueryPart queryPart = part;
        if (queryPart instanceof Union) {
            Union union = (Union)queryPart;
            seq2 = (Seq)union.unionedQueries().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.clauses(), Seq$.MODULE$.canBuildFrom());
        } else {
            if (!(queryPart instanceof SingleQuery)) throw new MatchError((Object)queryPart);
            SingleQuery singleQuery = (SingleQuery)queryPart;
            seq2 = singleQuery.clauses();
        }
        Seq seq3 = seq2;
        Seq clauses = seq3;
        boolean standaloneCall = clauses.forall((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)CypherAst$.$anonfun$getReturnTypes$2(x0$3)));
        if (standaloneCall) {
            CypherProcedureSignature sig;
            Clause clause = (Clause)clauses.head();
            if (!(clause instanceof UnresolvedCall)) throw new MatchError((Object)clause);
            UnresolvedCall unresolvedCall = (UnresolvedCall)clause;
            Namespace namespace = unresolvedCall.procedureNamespace();
            ProcedureName procedureName = unresolvedCall.procedureName();
            if (namespace == null) throw new MatchError((Object)clause);
            List namespaceParts = namespace.parts();
            if (procedureName == null) {
                throw new MatchError((Object)clause);
            }
            String name = procedureName.name();
            Tuple2 tuple2 = new Tuple2((Object)namespaceParts, (Object)name);
            Tuple2 tuple22 = tuple2;
            List namespaceParts2 = (List)tuple22._1();
            String name2 = (String)tuple22._2();
            String qualifiedName = CypherProcedures$.MODULE$.procedureName((Seq<String>)namespaceParts2, name2);
            Option option = procedures.get((Object)qualifiedName);
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringBuilder(21).append("Procedure not found: ").append(qualifiedName).toString());
            }
            Some some = (Some)option;
            CypherProcedureSignature cypherProcedureSignature = sig = (CypherProcedureSignature)some.value();
            CypherProcedureSignature signature = cypherProcedureSignature;
            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(signature.getResults()).asScala()).map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)b.getName(), (Object)MODULE$.bindingType(b.getType())), Buffer$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)((TraversableLike)((TraversableLike)clauses.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Iterable iterable;
                Clause clause = x0$4;
                if (clause instanceof Return) {
                    Return return_ = (Return)clause;
                    ReturnItemsDef returnItems = return_.returnItems();
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)returnItems.items()));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                LogicalVariable variable;
                Expression expression;
                block3: {
                    ReturnItem returnItem;
                    block2: {
                        returnItem = x0$5;
                        if (!(returnItem instanceof AliasedReturnItem)) break block2;
                        AliasedReturnItem aliasedReturnItem = (AliasedReturnItem)returnItem;
                        expression = aliasedReturnItem.expression();
                        variable = aliasedReturnItem.variable();
                        if (variable instanceof Variable) break block3;
                    }
                    throw new IllegalStateException(new StringBuilder(23).append("Unaliased return item: ").append(returnItem).toString());
                }
                Variable variable2 = (Variable)variable;
                String name = variable2.name();
                CypherType typ = (CypherType)expressionTypes.get((Object)expression).orElse((Function0 & Serializable & scala.Serializable)() -> expressionTypes.get((Object)variable2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.CTAny());
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)typ);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq items = seq;
        return (scala.collection.immutable.Map)ListMap$.MODULE$.apply(items);
    }

    private CypherType bindingType(CypherBindingType typ) {
        AnyType anyType;
        CypherBindingType cypherBindingType = typ;
        if (((Object)((Object)CypherBindingType.ANY)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTAny();
        } else if (((Object)((Object)CypherBindingType.BOOLEAN)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTBoolean();
        } else if (((Object)((Object)CypherBindingType.STRING)).equals((Object)cypherBindingType)) {
            anyType = (CypherType)package$.MODULE$.CTString();
        } else if (((Object)((Object)CypherBindingType.NUMBER)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTNumber();
        } else if (((Object)((Object)CypherBindingType.FLOAT)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTFloat();
        } else if (((Object)((Object)CypherBindingType.INTEGER)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTInteger();
        } else if (((Object)((Object)CypherBindingType.MAP)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTMap();
        } else if (((Object)((Object)CypherBindingType.LIST)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny());
        } else if (((Object)((Object)CypherBindingType.NODE)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTNode();
        } else if (((Object)((Object)CypherBindingType.RELATIONSHIP)).equals((Object)cypherBindingType)) {
            anyType = package$.MODULE$.CTRelationship();
        } else {
            throw new MatchError((Object)cypherBindingType);
        }
        return anyType;
    }

    public static final /* synthetic */ boolean $anonfun$getReturnTypes$2(Clause x0$3) {
        UnresolvedCall unresolvedCall;
        Option option;
        Clause clause = x0$3;
        boolean bl = clause instanceof UnresolvedCall && None$.MODULE$.equals(option = (unresolvedCall = (UnresolvedCall)clause).declaredResult());
        return bl;
    }

    private CypherAst$() {
        MODULE$ = this;
    }
}

