/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Arrays;
import java.util.Objects;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgTokvEntry;

class HgTokvEntryImpl
implements HgTokvEntry {
    private final String table;
    private final HgOwnerKey ownerKey;
    private final byte[] value;

    HgTokvEntryImpl(String table, HgOwnerKey ownerKey, byte[] value) {
        this.table = table;
        this.ownerKey = ownerKey;
        this.value = value;
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public HgOwnerKey ownerKey() {
        return this.ownerKey;
    }

    @Override
    public byte[] value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgTokvEntryImpl that = (HgTokvEntryImpl)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.ownerKey, that.ownerKey) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.table, this.ownerKey);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "HgTokvEntryImpl{table='" + this.table + "', okv=" + String.valueOf(this.ownerKey) + ", value=" + Arrays.toString(this.value) + "}";
    }
}

