/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.hugegraph.backend.Shard;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseProperty;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.NumericUtil;

public abstract class Condition {
    public static Condition and(Condition left, Condition right) {
        return new And(left, right);
    }

    public static Condition or(Condition left, Condition right) {
        return new Or(left, right);
    }

    public static Condition not(Condition condition) {
        return new Not(condition);
    }

    public static Relation eq(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.EQ, value);
    }

    public static Relation gt(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.GT, value);
    }

    public static Relation gte(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.GTE, value);
    }

    public static Relation lt(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.LT, value);
    }

    public static Relation lte(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.LTE, value);
    }

    public static Relation neq(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.NEQ, value);
    }

    public static Condition in(HugeKeys key, List<?> value) {
        return new SyspropRelation(key, RelationType.IN, value);
    }

    public static Condition nin(HugeKeys key, List<?> value) {
        return new SyspropRelation(key, RelationType.NOT_IN, value);
    }

    public static Condition prefix(HugeKeys key, Id value) {
        return new SyspropRelation(key, RelationType.PREFIX, value);
    }

    public static Condition containsValue(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.CONTAINS_VALUE, value);
    }

    public static Condition containsKey(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.CONTAINS_KEY, value);
    }

    public static Condition contains(HugeKeys key, Object value) {
        return new SyspropRelation(key, RelationType.CONTAINS, value);
    }

    public static Condition scan(String start, String end) {
        Shard value = new Shard(start, end, 0L);
        return new SyspropRelation(HugeKeys.ID, RelationType.SCAN, value);
    }

    public static Relation eq(Id key, Object value) {
        return new UserpropRelation(key, RelationType.EQ, value);
    }

    public static Relation gt(Id key, Object value) {
        return new UserpropRelation(key, RelationType.GT, value);
    }

    public static Relation gte(Id key, Object value) {
        return new UserpropRelation(key, RelationType.GTE, value);
    }

    public static Relation lt(Id key, Object value) {
        return new UserpropRelation(key, RelationType.LT, value);
    }

    public static Relation lte(Id key, Object value) {
        return new UserpropRelation(key, RelationType.LTE, value);
    }

    public static Relation neq(Id key, Object value) {
        return new UserpropRelation(key, RelationType.NEQ, value);
    }

    public static Relation in(Id key, List<?> value) {
        return new UserpropRelation(key, RelationType.IN, value);
    }

    public static Relation nin(Id key, List<?> value) {
        return new UserpropRelation(key, RelationType.NOT_IN, value);
    }

    public static Relation textContains(Id key, String word) {
        return new UserpropRelation(key, RelationType.TEXT_CONTAINS, word);
    }

    public static Relation textContainsAny(Id key, Set<String> words) {
        return new UserpropRelation(key, RelationType.TEXT_CONTAINS_ANY, words);
    }

    public static Condition contains(Id key, Object value) {
        return new UserpropRelation(key, RelationType.CONTAINS, value);
    }

    public abstract ConditionType type();

    public abstract boolean isSysprop();

    public abstract List<? extends Relation> relations();

    public abstract boolean test(Object var1);

    public abstract boolean test(BaseElement var1);

    public abstract Condition copy();

    public abstract Condition replace(Relation var1, Relation var2);

    public Condition and(Condition other) {
        return new And(this, other);
    }

    public Condition or(Condition other) {
        return new Or(this, other);
    }

    public Condition not() {
        return new Not(this);
    }

    public boolean isRelation() {
        return this.type() == ConditionType.RELATION;
    }

    public boolean isLogic() {
        return this.type() == ConditionType.AND || this.type() == ConditionType.OR || this.type() == ConditionType.NOT;
    }

    public boolean isFlattened() {
        return this.isRelation();
    }

    public static class RangeConditions {
        private Object keyEq = null;
        private Object keyMin = null;
        private boolean keyMinEq = false;
        private Object keyMax = null;
        private boolean keyMaxEq = false;

        public RangeConditions(List<? extends Condition> conditions) {
            block7: for (Condition condition : conditions) {
                Relation r = (Relation)condition;
                switch (r.relation()) {
                    case EQ: {
                        this.keyEq = r.value();
                        continue block7;
                    }
                    case GTE: {
                        this.keyMinEq = true;
                        this.keyMin = r.value();
                        continue block7;
                    }
                    case GT: {
                        this.keyMin = r.value();
                        continue block7;
                    }
                    case LTE: {
                        this.keyMaxEq = true;
                        this.keyMax = r.value();
                        continue block7;
                    }
                    case LT: {
                        this.keyMax = r.value();
                        continue block7;
                    }
                }
                E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
            }
        }

        public Object keyEq() {
            return this.keyEq;
        }

        public Object keyMin() {
            return this.keyMin;
        }

        public Object keyMax() {
            return this.keyMax;
        }

        public boolean keyMinEq() {
            return this.keyMinEq;
        }

        public boolean keyMaxEq() {
            return this.keyMaxEq;
        }

        public boolean hasRange() {
            return this.keyMin != null || this.keyMax != null;
        }
    }

    public static class UserpropRelation
    extends Relation {
        private final Id key;

        public UserpropRelation(Id key, Object value) {
            this(key, RelationType.EQ, value);
        }

        public UserpropRelation(Id key, RelationType op, Object value) {
            E.checkNotNull((Object)op, (String)"relation type");
            this.key = key;
            this.relation = op;
            this.value = value;
        }

        @Override
        public Id key() {
            return this.key;
        }

        @Override
        public boolean isSysprop() {
            return false;
        }

        @Override
        public boolean test(BaseElement element) {
            Object value;
            BaseProperty prop = element.getProperty(this.key);
            Object v0 = value = prop != null ? prop.value() : null;
            if (value == null) {
                return false;
            }
            return this.relation.test((Object)value, this.value());
        }

        @Override
        public Relation copy() {
            UserpropRelation clone = new UserpropRelation(this.key, this.relation(), this.value);
            clone.serialKey(this.serialKey);
            clone.serialValue(this.serialValue);
            return clone;
        }
    }

    public static class FlattenSyspropRelation
    extends SyspropRelation {
        public FlattenSyspropRelation(SyspropRelation relation) {
            super(relation.key(), relation.relation(), relation.value());
        }

        @Override
        public boolean isFlattened() {
            return true;
        }
    }

    public static class SyspropRelation
    extends Relation {
        private final HugeKeys key;

        public SyspropRelation(HugeKeys key, Object value) {
            this(key, RelationType.EQ, value);
        }

        public SyspropRelation(HugeKeys key, RelationType op, Object value) {
            E.checkNotNull((Object)op, (String)"relation type");
            this.key = key;
            this.relation = op;
            this.value = value;
        }

        public HugeKeys key() {
            return this.key;
        }

        @Override
        public boolean isSysprop() {
            return true;
        }

        @Override
        public boolean test(BaseElement element) {
            E.checkNotNull((Object)element, (String)"element");
            Object value = element.sysprop(this.key);
            return this.relation.test(value, this.value());
        }

        @Override
        public Relation copy() {
            SyspropRelation clone = new SyspropRelation(this.key, this.relation(), this.value);
            clone.serialKey(this.serialKey);
            clone.serialValue(this.serialValue);
            return clone;
        }
    }

    public static abstract class Relation
    extends Condition {
        protected static final Set<RelationType> UNFLATTEN_RELATION_TYPES = ImmutableSet.of((Object)RelationType.IN, (Object)RelationType.NOT_IN, (Object)RelationType.TEXT_CONTAINS_ANY);
        protected RelationType relation;
        protected Object value;
        protected Object serialKey;
        protected Object serialValue;

        @Override
        public ConditionType type() {
            return ConditionType.RELATION;
        }

        public RelationType relation() {
            return this.relation;
        }

        public Object value() {
            return this.value;
        }

        public void value(Object value) {
            this.value = value;
        }

        public void serialKey(Object key) {
            this.serialKey = key;
        }

        public Object serialKey() {
            return this.serialKey != null ? this.serialKey : this.key();
        }

        public void serialValue(Object value) {
            this.serialValue = value;
        }

        public Object serialValue() {
            return this.serialValue != null ? this.serialValue : this.value();
        }

        @Override
        public boolean test(Object value) {
            return this.relation.test(value, this.value());
        }

        @Override
        public boolean isFlattened() {
            return !UNFLATTEN_RELATION_TYPES.contains(this.relation);
        }

        @Override
        public List<? extends Relation> relations() {
            return ImmutableList.of((Object)this);
        }

        @Override
        public Condition replace(Relation from, Relation to) {
            if (this == from) {
                return to;
            }
            return this;
        }

        public String toString() {
            String sb = String.valueOf(this.key()) + " " + this.relation.string() + " " + String.valueOf(this.value);
            return sb;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation other = (Relation)object;
            return this.relation().equals(other.relation()) && this.key().equals(other.key()) && this.value().equals(other.value());
        }

        public int hashCode() {
            return this.type().hashCode() ^ this.relation().hashCode() ^ this.key().hashCode() ^ this.value().hashCode();
        }

        @Override
        public abstract boolean isSysprop();

        public abstract Object key();

        @Override
        public abstract Relation copy();
    }

    public static class Not
    extends Condition {
        Condition condition;

        public Not(Condition condition) {
            this.condition = condition;
        }

        public Condition condition() {
            return this.condition;
        }

        @Override
        public ConditionType type() {
            return ConditionType.NOT;
        }

        @Override
        public boolean test(Object value) {
            return !this.condition.test(value);
        }

        @Override
        public boolean test(BaseElement element) {
            return !this.condition.test(element);
        }

        @Override
        public Condition copy() {
            return new Not(this.condition.copy());
        }

        @Override
        public boolean isSysprop() {
            return this.condition.isSysprop();
        }

        @Override
        public List<? extends Relation> relations() {
            return new ArrayList<Relation>(this.condition.relations());
        }

        @Override
        public Condition replace(Relation from, Relation to) {
            this.condition = this.condition.replace(from, to);
            return this;
        }

        public String toString() {
            String sb = this.type().name() + " " + String.valueOf(this.condition);
            return sb;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Not)) {
                return false;
            }
            Not other = (Not)object;
            return this.type().equals((Object)other.type()) && this.condition.equals(other.condition());
        }

        public int hashCode() {
            return this.type().hashCode() ^ this.condition.hashCode();
        }
    }

    public static class Or
    extends BinCondition {
        public Or(Condition left, Condition right) {
            super(left, right);
        }

        @Override
        public ConditionType type() {
            return ConditionType.OR;
        }

        @Override
        public boolean test(Object value) {
            return this.left().test(value) || this.right().test(value);
        }

        @Override
        public boolean test(BaseElement element) {
            return this.left().test(element) || this.right().test(element);
        }

        @Override
        public Condition copy() {
            return new Or(this.left().copy(), this.right().copy());
        }
    }

    public static class And
    extends BinCondition {
        public And(Condition left, Condition right) {
            super(left, right);
        }

        @Override
        public ConditionType type() {
            return ConditionType.AND;
        }

        @Override
        public boolean test(Object value) {
            return this.left().test(value) && this.right().test(value);
        }

        @Override
        public boolean test(BaseElement element) {
            return this.left().test(element) && this.right().test(element);
        }

        @Override
        public Condition copy() {
            return new And(this.left().copy(), this.right().copy());
        }
    }

    public static abstract class BinCondition
    extends Condition {
        private Condition left;
        private Condition right;

        public BinCondition(Condition left, Condition right) {
            E.checkNotNull((Object)left, (String)"left condition");
            E.checkNotNull((Object)right, (String)"right condition");
            this.left = left;
            this.right = right;
        }

        public Condition left() {
            return this.left;
        }

        public Condition right() {
            return this.right;
        }

        @Override
        public boolean isSysprop() {
            return this.left.isSysprop() && this.right.isSysprop();
        }

        @Override
        public List<? extends Relation> relations() {
            ArrayList<? extends Relation> list = new ArrayList<Relation>(this.left.relations());
            list.addAll(this.right.relations());
            return list;
        }

        @Override
        public Condition replace(Relation from, Relation to) {
            this.left = this.left.replace(from, to);
            this.right = this.right.replace(from, to);
            return this;
        }

        public String toString() {
            String sb = String.valueOf(this.left) + " " + this.type().name() + " " + String.valueOf(this.right);
            return sb;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BinCondition)) {
                return false;
            }
            BinCondition other = (BinCondition)object;
            return this.type().equals((Object)other.type()) && this.left().equals(other.left()) && this.right().equals(other.right());
        }

        public int hashCode() {
            return this.type().hashCode() ^ this.left().hashCode() ^ this.right().hashCode();
        }
    }

    public static final class RelationType
    extends Enum<RelationType>
    implements BiPredicate<Object, Object> {
        public static final /* enum */ RelationType EQ = new RelationType("==", RelationType::equals);
        public static final /* enum */ RelationType GT = new RelationType(">", (v1, v2) -> RelationType.compare(v1, v2) > 0);
        public static final /* enum */ RelationType GTE = new RelationType(">=", (v1, v2) -> RelationType.compare(v1, v2) >= 0);
        public static final /* enum */ RelationType LT = new RelationType("<", (v1, v2) -> RelationType.compare(v1, v2) < 0);
        public static final /* enum */ RelationType LTE = new RelationType("<=", (v1, v2) -> RelationType.compare(v1, v2) <= 0);
        public static final /* enum */ RelationType NEQ = new RelationType("!=", (v1, v2) -> RelationType.compare(v1, v2) != 0);
        public static final /* enum */ RelationType IN = new RelationType("in", null, Collection.class, (v1, v2) -> {
            assert (v2 != null);
            return ((Collection)v2).contains(v1);
        });
        public static final /* enum */ RelationType NOT_IN = new RelationType("notin", null, Collection.class, (v1, v2) -> {
            assert (v2 != null);
            return !((Collection)v2).contains(v1);
        });
        public static final /* enum */ RelationType PREFIX = new RelationType("prefix", Id.class, Id.class, (v1, v2) -> {
            assert (v2 != null);
            return v1 != null && Bytes.prefixWith((byte[])((Id)v2).asBytes(), (byte[])((Id)v1).asBytes());
        });
        public static final /* enum */ RelationType TEXT_ANALYZER_CONTAINS = new RelationType("analyzercontains", String.class, String.class, (v1, v2) -> v1 != null && ((String)v1).toLowerCase().contains(((String)v2).toLowerCase()));
        public static final /* enum */ RelationType TEXT_CONTAINS = new RelationType("textcontains", String.class, String.class, (v1, v2) -> v1 != null && ((String)v1).contains((String)v2));
        public static final /* enum */ RelationType TEXT_MATCH_REGEX = new RelationType("textmatchregex", String.class, String.class, (v1, v2) -> Pattern.matches((String)v2, (String)v1));
        public static final /* enum */ RelationType TEXT_MATCH_EDIT_DISTANCE = new RelationType("texteditdistance", String.class, String.class, (v1, v2) -> {
            String content = (String)v2;
            String distanceStr = content.substring(0, content.indexOf("#"));
            int distance = Integer.valueOf(distanceStr);
            String target = content.substring(content.indexOf("#") + 1);
            return RelationType.minEditDistance((String)v1, target) <= distance;
        });
        public static final /* enum */ RelationType TEXT_NOT_CONTAINS = new RelationType("textnotcontains", String.class, String.class, (v1, v2) -> v1 == null && v2 != null || !((String)v1).toLowerCase().contains(((String)v2).toLowerCase()));
        public static final /* enum */ RelationType TEXT_PREFIX = new RelationType("textprefix", String.class, String.class, (v1, v2) -> ((String)v1).startsWith((String)v2));
        public static final /* enum */ RelationType TEXT_NOT_PREFIX = new RelationType("textnotprefix", String.class, String.class, (v1, v2) -> !((String)v1).startsWith((String)v2));
        public static final /* enum */ RelationType TEXT_SUFFIX = new RelationType("textsuffix", String.class, String.class, (v1, v2) -> ((String)v1).endsWith((String)v2));
        public static final /* enum */ RelationType TEXT_NOT_SUFFIX = new RelationType("textnotsuffix", String.class, String.class, (v1, v2) -> !((String)v1).endsWith((String)v2));
        public static final /* enum */ RelationType TEXT_CONTAINS_ANY = new RelationType("textcontainsany", String.class, Collection.class, (v1, v2) -> {
            assert (v2 != null);
            if (v1 == null) {
                return false;
            }
            Collection words = (Collection)v2;
            for (String word : words) {
                if (!((String)v1).contains(word)) continue;
                return true;
            }
            return false;
        });
        public static final /* enum */ RelationType CONTAINS = new RelationType("contains", Collection.class, null, (v1, v2) -> {
            assert (v2 != null);
            return v1 != null && ((Collection)v1).contains(v2);
        });
        public static final /* enum */ RelationType CONTAINS_VALUE = new RelationType("containsv", Map.class, null, (v1, v2) -> {
            assert (v2 != null);
            return v1 != null && ((Map)v1).containsValue(v2);
        });
        public static final /* enum */ RelationType CONTAINS_KEY = new RelationType("containsk", Map.class, null, (v1, v2) -> {
            assert (v2 != null);
            return v1 != null && ((Map)v1).containsKey(v2);
        });
        public static final /* enum */ RelationType TEXT_CONTAINS_FUZZY = new RelationType("textcontainsfuzzy", String.class, String.class, (v1, v2) -> {
            for (String token : RelationType.tokenize(((String)v1).toLowerCase())) {
                if (!RelationType.isFuzzy(((String)v2).toLowerCase(), token)) continue;
                return true;
            }
            return false;
        });
        public static final /* enum */ RelationType TEXT_FUZZY = new RelationType("textfuzzy", String.class, String.class, (v1, v2) -> RelationType.isFuzzy((String)v2, (String)v1));
        public static final /* enum */ RelationType TEXT_CONTAINS_REGEX = new RelationType("textcontainsregex", String.class, String.class, (v1, v2) -> {
            for (String token : RelationType.tokenize(((String)v1).toLowerCase())) {
                if (!token.matches((String)v2)) continue;
                return true;
            }
            return false;
        });
        public static final /* enum */ RelationType TEXT_REGEX = new RelationType("textregex", String.class, String.class, (v1, v2) -> ((String)v1).matches((String)v2));
        public static final /* enum */ RelationType SCAN = new RelationType("scan", (v1, v2) -> {
            assert (v2 != null);
            return true;
        });
        private static final LevenshteinDistance ONE_LEVENSHTEIN_DISTANCE;
        private static final LevenshteinDistance TWO_LEVENSHTEIN_DISTANCE;
        private final String operator;
        private final BiFunction<Object, Object, Boolean> tester;
        private final Class<?> v1Class;
        private final Class<?> v2Class;
        private static final /* synthetic */ RelationType[] $VALUES;

        public static RelationType[] values() {
            return (RelationType[])$VALUES.clone();
        }

        public static RelationType valueOf(String name) {
            return Enum.valueOf(RelationType.class, name);
        }

        private RelationType(String op, BiFunction<Object, Object, Boolean> tester) {
            this(op, null, null, tester);
        }

        private RelationType(String op, Class<?> v1Class, Class<?> v2Class, BiFunction<Object, Object, Boolean> tester) {
            this.operator = op;
            this.tester = tester;
            this.v1Class = v1Class;
            this.v2Class = v2Class;
        }

        private static int minEditDistance(String source, String target) {
            E.checkArgument((source != null ? 1 : 0) != 0, (String)"The source could not be null", (Object[])new Object[0]);
            E.checkArgument((target != null ? 1 : 0) != 0, (String)"The target could not be null", (Object[])new Object[0]);
            int sourceLen = source.length();
            int targetLen = target.length();
            if (sourceLen == 0) {
                return targetLen;
            }
            if (targetLen == 0) {
                return sourceLen;
            }
            int[][] arr = new int[sourceLen + 1][targetLen + 1];
            for (int i = 0; i < sourceLen + 1; ++i) {
                arr[i][0] = i;
            }
            for (int j = 0; j < targetLen + 1; ++j) {
                arr[0][j] = j;
            }
            Character sourceChar = null;
            Character targetChar = null;
            for (int i = 1; i < sourceLen + 1; ++i) {
                sourceChar = Character.valueOf(source.charAt(i - 1));
                for (int j = 1; j < targetLen + 1; ++j) {
                    targetChar = Character.valueOf(target.charAt(j - 1));
                    arr[i][j] = sourceChar.equals(targetChar) ? arr[i - 1][j - 1] : Math.min(Math.min(arr[i - 1][j], arr[i][j - 1]), arr[i - 1][j - 1]) + 1;
                }
            }
            return arr[sourceLen][targetLen];
        }

        private static boolean equals(Object first, Object second) {
            assert (second != null);
            if (first instanceof Id) {
                if (second instanceof String) {
                    return second.equals(((Id)first).asString());
                }
                if (second instanceof Long) {
                    return second.equals(((Id)first).asLong());
                }
            } else {
                if (second instanceof Number) {
                    return RelationType.compare(first, second) == 0;
                }
                if (second.getClass().isArray()) {
                    return ArrayUtils.isEquals((Object)first, (Object)second);
                }
            }
            return Objects.equals(first, second);
        }

        private static int compare(Object first, Object second) {
            assert (second != null);
            if (second instanceof Number) {
                return NumericUtil.compareNumber((Object)(first == null ? Integer.valueOf(0) : first), (Number)((Number)second));
            }
            if (second instanceof Date) {
                return RelationType.compareDate(first, (Date)second);
            }
            throw new IllegalArgumentException(String.format("Can't compare between %s(%s) and %s(%s)", first, first == null ? null : first.getClass().getSimpleName(), second, second.getClass().getSimpleName()));
        }

        private static int compareDate(Object first, Date second) {
            if (first == null) {
                first = DateUtil.DATE_ZERO;
            }
            if (first instanceof Date) {
                return ((Date)first).compareTo(second);
            }
            throw new IllegalArgumentException(String.format("Can't compare between %s(%s) and %s(%s)", first, first.getClass().getSimpleName(), second, second.getClass().getSimpleName()));
        }

        public static List<String> tokenize(String str) {
            ArrayList<String> tokens = new ArrayList<String>();
            int previous = 0;
            for (int p = 0; p < str.length(); ++p) {
                if (Character.isLetterOrDigit(str.charAt(p))) continue;
                if (p > previous + 1) {
                    tokens.add(str.substring(previous, p));
                }
                previous = p + 1;
            }
            if (previous + 1 < str.length()) {
                tokens.add(str.substring(previous));
            }
            return tokens;
        }

        private static boolean isFuzzy(String term, String value) {
            int length = (term = term.trim()).length();
            if (length < 3) {
                return term.equals(value);
            }
            if (length < 6) {
                int distance = ONE_LEVENSHTEIN_DISTANCE.apply((CharSequence)value, (CharSequence)term);
                return distance <= 1 && distance >= 0;
            }
            int distance = TWO_LEVENSHTEIN_DISTANCE.apply((CharSequence)value, (CharSequence)term);
            return distance <= 2 && distance >= 0;
        }

        public String string() {
            return this.operator;
        }

        private void checkBaseType(Object value, Class<?> clazz) {
            if (!clazz.isInstance(value)) {
                String valueClass = value == null ? "null" : value.getClass().getSimpleName();
                E.checkArgument((boolean)false, (String)"Can't execute `%s` on type %s, expect %s", (Object[])new Object[]{this.operator, valueClass, clazz.getSimpleName()});
            }
        }

        private void checkValueType(Object value, Class<?> clazz) {
            if (!clazz.isInstance(value)) {
                String valueClass = value == null ? "null" : value.getClass().getSimpleName();
                E.checkArgument((boolean)false, (String)"Can't test '%s'(%s) for `%s`, expect %s", (Object[])new Object[]{value, valueClass, this.operator, clazz.getSimpleName()});
            }
        }

        @Override
        public boolean test(Object first, Object second) {
            E.checkState((this.tester != null ? 1 : 0) != 0, (String)"Can't test %s", (Object[])new Object[]{this.name()});
            E.checkArgument((second != null ? 1 : 0) != 0, (String)"Can't test null value for `%s`", (Object[])new Object[]{this.operator});
            if (this.v1Class != null) {
                this.checkBaseType(first, this.v1Class);
            }
            if (this.v2Class != null) {
                this.checkValueType(second, this.v2Class);
            }
            return this.tester.apply(first, second);
        }

        public boolean isFuzzyType() {
            return this == TEXT_CONTAINS || this == TEXT_NOT_CONTAINS || this == TEXT_NOT_PREFIX || this == TEXT_PREFIX || this == TEXT_SUFFIX || this == TEXT_NOT_SUFFIX || this == TEXT_CONTAINS_FUZZY || this == TEXT_FUZZY || this == TEXT_CONTAINS_REGEX || this == TEXT_REGEX || this == TEXT_CONTAINS_ANY || this == TEXT_MATCH_REGEX || this == TEXT_MATCH_EDIT_DISTANCE;
        }

        public boolean isRangeType() {
            return ImmutableSet.of((Object)GT, (Object)GTE, (Object)LT, (Object)LTE).contains((Object)this);
        }

        public boolean isSearchType() {
            return this == TEXT_CONTAINS || this == TEXT_CONTAINS_ANY;
        }

        public boolean isSecondaryType() {
            return this == EQ;
        }

        static {
            $VALUES = new RelationType[]{EQ, GT, GTE, LT, LTE, NEQ, IN, NOT_IN, PREFIX, TEXT_ANALYZER_CONTAINS, TEXT_CONTAINS, TEXT_MATCH_REGEX, TEXT_MATCH_EDIT_DISTANCE, TEXT_NOT_CONTAINS, TEXT_PREFIX, TEXT_NOT_PREFIX, TEXT_SUFFIX, TEXT_NOT_SUFFIX, TEXT_CONTAINS_ANY, CONTAINS, CONTAINS_VALUE, CONTAINS_KEY, TEXT_CONTAINS_FUZZY, TEXT_FUZZY, TEXT_CONTAINS_REGEX, TEXT_REGEX, SCAN};
            ONE_LEVENSHTEIN_DISTANCE = new LevenshteinDistance(Integer.valueOf(1));
            TWO_LEVENSHTEIN_DISTANCE = new LevenshteinDistance(Integer.valueOf(2));
        }
    }

    public static enum ConditionType {
        NONE,
        RELATION,
        AND,
        OR,
        NOT;

    }
}

