/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;

@ChannelHandler.Sharable
public class WsAndHttpBasicAuthHandler
extends SaslAuthenticationHandler {
    private static final String AUTHENTICATOR = "authenticator";
    private static final String HTTP_AUTH = "http-authentication";

    public WsAndHttpBasicAuthHandler(Authenticator authenticator, Settings settings) {
        super(authenticator, settings);
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof HttpMessage && !WsAndHttpBasicAuthHandler.isWebSocket((HttpMessage)obj)) {
            ChannelPipeline pipeline = ctx.pipeline();
            Object authHandler = pipeline.get(HTTP_AUTH);
            authHandler = authHandler != null ? pipeline.remove(HTTP_AUTH) : new HttpBasicAuthHandler(this.authenticator);
            pipeline.addAfter(AUTHENTICATOR, HTTP_AUTH, authHandler);
            ctx.fireChannelRead(obj);
        } else {
            super.channelRead(ctx, obj);
        }
    }

    public static boolean isWebSocket(HttpMessage msg) {
        String connectionHeader = msg.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        String upgradeHeader = msg.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
        return "Upgrade".equalsIgnoreCase(connectionHeader) || "WebSocket".equalsIgnoreCase(upgradeHeader);
    }

    @ChannelHandler.Sharable
    private static class HttpBasicAuthHandler
    extends AbstractAuthenticationHandler {
        private final Base64.Decoder decoder = Base64.getUrlDecoder();

        public HttpBasicAuthHandler(Authenticator authenticator) {
            super(authenticator);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof FullHttpMessage) {
                FullHttpMessage request = (FullHttpMessage)msg;
                if (!request.headers().contains("Authorization")) {
                    this.sendError(ctx, msg);
                    return;
                }
                String basic = "Basic ";
                String header = request.headers().get("Authorization");
                if (!header.startsWith("Basic ")) {
                    this.sendError(ctx, msg);
                    return;
                }
                byte[] userPass = null;
                try {
                    String encoded = header.substring("Basic ".length());
                    userPass = this.decoder.decode(encoded);
                }
                catch (IndexOutOfBoundsException iae) {
                    this.sendError(ctx, msg);
                    return;
                }
                catch (IllegalArgumentException iae) {
                    this.sendError(ctx, msg);
                    return;
                }
                String authorization = new String(userPass, StandardCharsets.UTF_8);
                String[] split = authorization.split(":");
                if (split.length != 2) {
                    this.sendError(ctx, msg);
                    return;
                }
                String address = ctx.channel().remoteAddress().toString();
                if (address.startsWith("/") && address.length() > 1) {
                    address = address.substring(1);
                }
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put("username", split[0]);
                credentials.put("password", split[1]);
                credentials.put("address", address);
                try {
                    this.authenticator.authenticate(credentials);
                    ctx.fireChannelRead((Object)request);
                }
                catch (AuthenticationException ae) {
                    this.sendError(ctx, msg);
                }
            }
        }

        private void sendError(ChannelHandlerContext context, Object msg) {
            context.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

