/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.scylladb;

import com.datastax.driver.core.querybuilder.Select;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraTable;
import org.apache.hugegraph.backend.store.cassandra.CassandraTables;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;

public class ScyllaDBTablesWithMV {
    private static boolean isQueryBySpecifiedKey(Query query, HugeKeys key) {
        Collection conditions = query.conditions();
        if (query instanceof ConditionQuery && !conditions.isEmpty()) {
            ConditionQuery cq = (ConditionQuery)query;
            Object value = cq.condition((Object)key);
            return value != null && cq.allSysprop() && conditions.size() == 1 && cq.containsRelation(key, Condition.RelationType.EQ);
        }
        return false;
    }

    private static boolean isQueryByLabel(Query query) {
        return ScyllaDBTablesWithMV.isQueryBySpecifiedKey(query, HugeKeys.LABEL);
    }

    private static boolean isQueryByName(Query query) {
        return ScyllaDBTablesWithMV.isQueryBySpecifiedKey(query, HugeKeys.NAME);
    }

    private static String mvNameTable(String table) {
        return "mv_name2" + table;
    }

    private static String mvLabelTable(String table) {
        return "mv_label2" + table;
    }

    private static void createSchemaIndexTable(CassandraSessionPool.Session session, String mvName, String table) {
        String NAME = CassandraTable.formatKey((HugeKeys)HugeKeys.NAME);
        String ID = CassandraTable.formatKey((HugeKeys)HugeKeys.ID);
        String cql = String.format("CREATE MATERIALIZED VIEW IF NOT EXISTS %s AS   SELECT * FROM %s   WHERE %s IS NOT NULL   PRIMARY KEY(%s, %s)", mvName, table, NAME, NAME, ID);
        session.execute(cql);
    }

    private static void dropIndexTable(CassandraSessionPool.Session session, String mvName) {
        String cql = String.format("DROP MATERIALIZED VIEW IF EXISTS %s", mvName);
        session.execute(cql);
    }

    public static class Edge
    extends CassandraTables.Edge {
        private final String mvLabel2Edge = ScyllaDBTablesWithMV.mvLabelTable(this.table());
        private static final String LABEL = CassandraTable.formatKey((HugeKeys)HugeKeys.LABEL);
        private final List<String> keys = this.idColumnName().stream().filter(k -> k != HugeKeys.LABEL).map(CassandraTable::formatKey).collect(Collectors.toList());
        private final String prKeys = this.keys.stream().collect(Collectors.joining(","));
        private final String prkeysNn = this.keys.stream().collect(Collectors.joining(" IS NOT NULL AND "));

        public Edge(String store, Directions direction) {
            super(store, direction);
        }

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            String cql = String.format("CREATE MATERIALIZED VIEW IF NOT EXISTS %s AS   SELECT * FROM %s   WHERE %s IS NOT NULL AND %s IS NOT NULL   PRIMARY KEY(%s, %s)", this.mvLabel2Edge, this.table(), LABEL, this.prkeysNn, LABEL, this.prKeys);
            session.execute(cql);
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvLabel2Edge);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByLabel(query)) {
                return super.query2Select(this.mvLabel2Edge, query);
            }
            return super.query2Select(table, query);
        }

        protected String labelIndexTable() {
            return this.mvLabel2Edge;
        }

        public static Edge out(String store) {
            return new Edge(store, Directions.OUT);
        }

        public static Edge in(String store) {
            return new Edge(store, Directions.IN);
        }
    }

    public static class Vertex
    extends CassandraTables.Vertex {
        private final String mvLabel2Vertex = ScyllaDBTablesWithMV.mvLabelTable(this.table());

        public Vertex(String store) {
            super(store);
        }

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            String LABEL = CassandraTable.formatKey((HugeKeys)HugeKeys.LABEL);
            String ID = CassandraTable.formatKey((HugeKeys)HugeKeys.ID);
            String cql = String.format("CREATE MATERIALIZED VIEW IF NOT EXISTS %s AS   SELECT * FROM %s   WHERE %s IS NOT NULL   PRIMARY KEY(%s, %s)", this.mvLabel2Vertex, this.table(), LABEL, LABEL, ID);
            session.execute(cql);
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvLabel2Vertex);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByLabel(query)) {
                return super.query2Select(this.mvLabel2Vertex, query);
            }
            return super.query2Select(table, query);
        }
    }

    public static class IndexLabel
    extends CassandraTables.IndexLabel {
        private final String mvName2Il = ScyllaDBTablesWithMV.mvNameTable(this.table());

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            ScyllaDBTablesWithMV.createSchemaIndexTable(session, this.mvName2Il, this.table());
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvName2Il);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByName(query)) {
                return super.query2Select(this.mvName2Il, query);
            }
            return super.query2Select(table, query);
        }
    }

    public static class EdgeLabel
    extends CassandraTables.EdgeLabel {
        private final String mvName2El = ScyllaDBTablesWithMV.mvNameTable(this.table());

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            ScyllaDBTablesWithMV.createSchemaIndexTable(session, this.mvName2El, this.table());
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvName2El);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByName(query)) {
                return super.query2Select(this.mvName2El, query);
            }
            return super.query2Select(table, query);
        }
    }

    public static class VertexLabel
    extends CassandraTables.VertexLabel {
        private final String mvName2Vl = ScyllaDBTablesWithMV.mvNameTable(this.table());

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            ScyllaDBTablesWithMV.createSchemaIndexTable(session, this.mvName2Vl, this.table());
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvName2Vl);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByName(query)) {
                return super.query2Select(this.mvName2Vl, query);
            }
            return super.query2Select(table, query);
        }
    }

    public static class PropertyKey
    extends CassandraTables.PropertyKey {
        private final String mvName2Pk = ScyllaDBTablesWithMV.mvNameTable(this.table());

        protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
            ScyllaDBTablesWithMV.createSchemaIndexTable(session, this.mvName2Pk, this.table());
        }

        protected void dropTable(CassandraSessionPool.Session session) {
            ScyllaDBTablesWithMV.dropIndexTable(session, this.mvName2Pk);
            super.dropTable(session);
        }

        protected List<Select> query2Select(String table, Query query) {
            if (ScyllaDBTablesWithMV.isQueryByName(query)) {
                return super.query2Select(this.mvName2Pk, query);
            }
            return super.query2Select(table, query);
        }
    }
}

