/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

class DelayedCancellableThenSubscription
implements PublisherSource.Subscription {
    private final DelayedSubscription delayedSubscription = new DelayedSubscription();
    private static final AtomicReferenceFieldUpdater<DelayedCancellableThenSubscription, Cancellable> currentUpdater = AtomicReferenceFieldUpdater.newUpdater(DelayedCancellableThenSubscription.class, Cancellable.class, "current");
    @Nullable
    private volatile Cancellable current;

    DelayedCancellableThenSubscription() {
    }

    public void request(long n) {
        this.delayedSubscription.request(n);
    }

    public void cancel() {
        try {
            Cancellable oldCancellable = currentUpdater.getAndSet(this, IGNORE_CANCEL);
            if (oldCancellable != null) {
                oldCancellable.cancel();
            }
        }
        finally {
            this.delayedSubscription.cancel();
        }
    }

    final void delayedCancellable(Cancellable delayedCancellable) {
        if (!currentUpdater.compareAndSet(this, null, Objects.requireNonNull(delayedCancellable))) {
            delayedCancellable.cancel();
        }
    }

    final void delayedSubscription(PublisherSource.Subscription subscription) {
        this.current = IGNORE_CANCEL;
        this.delayedSubscription.delayedSubscription(subscription);
    }
}

