/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.internal.ContextMapUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ConcurrentContextMap
implements ContextMap {
    private final ConcurrentMap<ContextMap.Key<?>, Object> theMap;

    ConcurrentContextMap() {
        this.theMap = new ConcurrentHashMap(4);
    }

    private ConcurrentContextMap(ConcurrentContextMap rhs) {
        this.theMap = new ConcurrentHashMap(rhs.theMap);
    }

    public int size() {
        return this.theMap.size();
    }

    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    public boolean containsKey(ContextMap.Key<?> key) {
        return this.theMap.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value) {
        assert (value != null);
        return this.theMap.containsValue(value);
    }

    public <T> boolean contains(ContextMap.Key<T> key, @Nullable T value) {
        T current = this.get(key);
        return current != null && current.equals(value);
    }

    @Nullable
    public <T> T get(ContextMap.Key<T> key) {
        return (T)this.theMap.get(key);
    }

    @Nullable
    public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
        return (T)this.theMap.getOrDefault(key, defaultValue);
    }

    @Nullable
    public <T> T put(ContextMap.Key<T> key, @Nullable T value) {
        assert (value != null);
        return this.theMap.put(key, value);
    }

    @Nullable
    public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value) {
        assert (value != null);
        return (T)this.theMap.putIfAbsent(key, value);
    }

    @Nullable
    public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction) {
        return (T)this.theMap.computeIfAbsent(key, (? super K k) -> computeFunction.apply((ContextMap.Key)k));
    }

    public void putAll(ContextMap map) {
        if (map instanceof ConcurrentContextMap) {
            ConcurrentContextMap ccm = (ConcurrentContextMap)map;
            this.theMap.putAll(ccm.theMap);
        } else {
            super.putAll(map);
        }
    }

    public void putAll(Map<ContextMap.Key<?>, Object> map) {
        map.forEach(ContextMapUtils::ensureType);
        this.theMap.putAll(map);
    }

    public <T> T remove(ContextMap.Key<T> key) {
        return (T)this.theMap.remove(key);
    }

    public boolean removeAll(Iterable<ContextMap.Key<?>> keys) {
        boolean removed = false;
        for (ContextMap.Key<?> k : keys) {
            removed |= this.theMap.remove(k) != null;
        }
        return removed;
    }

    public void clear() {
        this.theMap.clear();
    }

    @Nullable
    public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
        for (Map.Entry entry : this.theMap.entrySet()) {
            if (consumer.test((ContextMap.Key<?>)entry.getKey(), entry.getValue())) continue;
            return (ContextMap.Key)entry.getKey();
        }
        return null;
    }

    public ContextMap copy() {
        return new ConcurrentContextMap(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextMap)) {
            return false;
        }
        if (o instanceof ConcurrentContextMap) {
            return this.theMap.equals(((ConcurrentContextMap)o).theMap);
        }
        return ContextMapUtils.equals((ContextMap)this, (ContextMap)((ContextMap)o));
    }

    public int hashCode() {
        return this.theMap.hashCode();
    }

    public String toString() {
        return ContextMapUtils.toString((ContextMap)this);
    }
}

