/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record UngzipFile(Path file, Path directory) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(UngzipFile.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Unzipping {} to {}", (Object)this.file, (Object)this.directory);
        Path filePath = this.file.toAbsolutePath();
        Path directoryPath = this.directory.toAbsolutePath();
        try (GZIPInputStream zis = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0])));){
            Path file = directoryPath.resolve(filePath.getFileName().toString().substring(0, filePath.getFileName().toString().length() - 3));
            Files.copy(zis, file, StandardCopyOption.REPLACE_EXISTING);
            logger.info("Finished unzipping {} to {}", (Object)file, (Object)this.directory);
        }
        catch (Exception e) {
            logger.error("Failed unzipping {} to {}", (Object)this.file, (Object)this.directory);
            throw new WorkflowException(e);
        }
    }
}

