/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.util.HashMap;
import java.util.Map;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.PropertyType;
import org.locationtech.jts.geom.Geometry;

public class Entity
implements Feature {
    private final long id;
    private final Map<String, String> tags;
    private final Geometry geometry;

    public Entity(long id, Map<String, String> tags, Geometry geometry) {
        this.id = id;
        this.tags = tags;
        this.geometry = geometry;
    }

    @Override
    public FeatureType getType() {
        HashMap<String, PropertyType> map = new HashMap<String, PropertyType>();
        map.put("id", new PropertyType<Long>("id", Long.class));
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            map.put(entry.getKey(), new PropertyType<String>(entry.getKey(), String.class));
        }
        map.put("geometry", new PropertyType<Geometry>("geometry", Geometry.class));
        return new FeatureType("entity", map);
    }

    @Override
    public void setProperty(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("id")) {
            return this.id;
        }
        if (name.equals("geometry")) {
            return this.geometry;
        }
        return this.tags.get(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.putAll(this.tags);
        map.put("geometry", this.geometry);
        return map;
    }

    public long getId() {
        return this.id;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

