/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.state;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.baremaps.openstreetmap.model.State;

public class StateReader {
    public State state(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : CharStreams.readLines((Readable)reader)) {
            String[] array = line.split("=");
            if (array.length != 2) continue;
            map.put(array[0], array[1]);
        }
        long sequenceNumber = Long.parseLong((String)map.get("sequenceNumber"));
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        LocalDateTime timestamp = LocalDateTime.parse(((String)map.get("timestamp")).replace("\\", ""), format);
        return new State(sequenceNumber, timestamp);
    }
}

