/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.Weigher;
import java.nio.ByteBuffer;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileCache
implements TileStore {
    private static final Logger logger = LoggerFactory.getLogger(TileCache.class);
    private final TileStore tileStore;
    private final Cache<Tile, ByteBuffer> cache;

    public TileCache(TileStore tileStore, CaffeineSpec spec) {
        this.tileStore = tileStore;
        this.cache = Caffeine.from((CaffeineSpec)spec).weigher((Weigher)new Weigher<Tile, ByteBuffer>(){

            public @NonNegative int weigh(Tile tile, ByteBuffer blob) {
                return 28 + blob.capacity();
            }
        }).build();
    }

    @Override
    public ByteBuffer read(Tile tile) throws TileStoreException {
        return (ByteBuffer)this.cache.get((Object)tile, t -> {
            try {
                return this.tileStore.read((Tile)t).duplicate();
            }
            catch (TileStoreException e) {
                logger.error("Unable to read the tile.", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void write(Tile tile, ByteBuffer bytes) throws TileStoreException {
        this.tileStore.write(tile, bytes);
        this.cache.invalidate((Object)tile);
    }

    @Override
    public void delete(Tile tile) throws TileStoreException {
        this.tileStore.delete(tile);
        this.cache.invalidate((Object)tile);
    }
}

