/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.collection;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.baremaps.collection.DataCollectionException;

class PostgresIterator<T>
implements Iterator<T> {
    private final ResultSet resultSet;
    private final Function<ResultSet, T> mapper;

    public PostgresIterator(ResultSet resultSet, Function<ResultSet, T> mapper) {
        this.resultSet = resultSet;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.resultSet.next()) {
                return true;
            }
            this.resultSet.close();
            return false;
        }
        catch (SQLException e) {
            throw new DataCollectionException(e);
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mapper.apply(this.resultSet);
    }
}

