/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class IntegerListDataType
implements DataType<List<Integer>> {
    @Override
    public int size(List<Integer> values) {
        return 4 + values.size() * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Integer> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (Integer value : values) {
            buffer.putInt(position, value);
            position += 4;
        }
    }

    @Override
    public List<Integer> read(ByteBuffer buffer, int position) {
        int size = this.size(buffer, position);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int p = position + 4; p < position + size; p += 4) {
            list.add(buffer.getInt(p));
        }
        return list;
    }
}

