/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class FeatureTileGraphics {
    private static final int POLYGON_LAYER = 0;
    private static final int LINE_LAYER = 1;
    private static final int POINT_LAYER = 2;
    private static final int ICON_LAYER = 3;
    private final int tileWidth;
    private final int tileHeight;
    private final BufferedImage[] layeredImage = new BufferedImage[4];
    private final Graphics2D[] layeredGraphics = new Graphics2D[4];

    public FeatureTileGraphics(int tileWidth, int tileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public BufferedImage getPolygonImage() {
        return this.getImage(0);
    }

    public Graphics2D getPolygonGraphics() {
        return this.getGraphics(0);
    }

    public BufferedImage getLineImage() {
        return this.getImage(1);
    }

    public Graphics2D getLineGraphics() {
        return this.getGraphics(1);
    }

    public BufferedImage getPointImage() {
        return this.getImage(2);
    }

    public Graphics2D getPointGraphics() {
        return this.getGraphics(2);
    }

    public BufferedImage getIconImage() {
        return this.getImage(3);
    }

    public Graphics2D getIconGraphics() {
        return this.getGraphics(3);
    }

    public BufferedImage createImage() {
        BufferedImage image = null;
        Graphics graphics = null;
        for (int layer = 0; layer < 4; ++layer) {
            BufferedImage layerImage = this.layeredImage[layer];
            if (layerImage == null) continue;
            if (image == null) {
                image = layerImage;
                graphics = this.layeredGraphics[layer];
            } else {
                graphics.drawImage(layerImage, 0, 0, null);
                this.layeredGraphics[layer].dispose();
                layerImage.flush();
            }
            this.layeredImage[layer] = null;
            this.layeredGraphics[layer] = null;
        }
        if (graphics != null) {
            graphics.dispose();
        }
        return image;
    }

    public void dispose() {
        for (int layer = 0; layer < 4; ++layer) {
            BufferedImage image;
            Graphics2D graphics = this.layeredGraphics[layer];
            if (graphics != null) {
                graphics.dispose();
                this.layeredGraphics[layer] = null;
            }
            if ((image = this.layeredImage[layer]) == null) continue;
            image.flush();
            this.layeredImage[layer] = null;
        }
    }

    private BufferedImage getImage(int layer) {
        BufferedImage image = this.layeredImage[layer];
        if (image == null) {
            this.createImageAndGraphics(layer);
            image = this.layeredImage[layer];
        }
        return image;
    }

    private Graphics2D getGraphics(int layer) {
        Graphics2D graphics = this.layeredGraphics[layer];
        if (graphics == null) {
            this.createImageAndGraphics(layer);
            graphics = this.layeredGraphics[layer];
        }
        return graphics;
    }

    private void createImageAndGraphics(int layer) {
        this.layeredImage[layer] = new BufferedImage(this.tileWidth, this.tileHeight, 2);
        this.layeredGraphics[layer] = this.layeredImage[layer].createGraphics();
        this.layeredGraphics[layer].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

