/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.io.GeoPackageTextOutput;
import mil.nga.geopackage.io.TileFormatType;
import mil.nga.geopackage.io.TileReproject;
import mil.nga.geopackage.io.ZoomLevelProgress;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.UrlTileGenerator;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.proj.GeometryTransform;
import org.locationtech.proj4j.units.Units;

public class URLTileGen {
    private static final Logger LOGGER = Logger.getLogger(URLTileGen.class.getName());
    private static final int LOG_TILE_FREQUENCY = 100;
    private static final int LOG_TILE_TIME_FREQUENCY = 60;
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_COMPRESS_FORMAT = "f";
    public static final String ARGUMENT_COMPRESS_QUALITY = "q";
    public static final String ARGUMENT_XYZ_TILES = "xyz";
    public static final String ARGUMENT_BOUNDING_BOX = "bbox";
    public static final String ARGUMENT_EPSG = "epsg";
    public static final String ARGUMENT_URL_EPSG = "uepsg";
    public static final String ARGUMENT_TMS = "tms";
    public static final String ARGUMENT_REPLACE_EXISTING = "replace";
    public static final String ARGUMENT_LOG_COUNT = "logCount";
    public static final String ARGUMENT_LOG_TIME = "logTime";
    private static ZoomLevelProgress progress = new ZoomLevelProgress("URL Tile Generation", "tiles", 100, 60);
    private static File geoPackageFile = null;
    private static GeoPackage geoPackage = null;
    private static String tileTable = null;
    private static String url = null;
    private static String zoomValue = null;
    private static Integer maxZoom = null;
    private static List<Long> zoomLevels = null;
    private static String compressFormat = null;
    private static Float compressQuality = null;
    private static boolean xyzTiles = false;
    private static BoundingBox boundingBox = null;
    private static Long epsg = null;
    private static long urlEpsg = 3857L;
    private static boolean tms = false;
    private static boolean replaceExisting = false;

    public static void main(String[] args) {
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                progress.cancel();
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to wait for the main thread to finish", e);
                }
            }
        });
        boolean valid = true;
        boolean requiredArguments = false;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "f": {
                        if (i + 1 < args.length) {
                            compressFormat = args[++i];
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Compress Format argument '" + arg + "' must be followed by an image format");
                        break;
                    }
                    case "q": {
                        if (i + 1 < args.length) {
                            compressQuality = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Compress Quality argument '" + arg + "' must be followed by a value between 0.0 and 1.0");
                        break;
                    }
                    case "xyz": {
                        xyzTiles = true;
                        break;
                    }
                    case "bbox": {
                        if (i + 1 < args.length) {
                            String bbox;
                            String[] bboxParts;
                            if ((bboxParts = (bbox = args[++i]).split(",")).length != 4) {
                                valid = false;
                                System.out.println("Error: Bounding Box argument '" + arg + "' value must be in the format: minLon,minLat,maxLon,maxLat");
                                break;
                            }
                            double minLon = Double.valueOf(bboxParts[0]);
                            double minLat = Double.valueOf(bboxParts[1]);
                            double maxLon = Double.valueOf(bboxParts[2]);
                            double maxLat = Double.valueOf(bboxParts[3]);
                            boundingBox = new BoundingBox(minLon, minLat, maxLon, maxLat);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Bounding Box argument '" + arg + "' must be followed by bbox values: minLon,minLat,maxLon,maxLat");
                        break;
                    }
                    case "epsg": {
                        if (i + 1 < args.length) {
                            epsg = Long.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: EPSG argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "uepsg": {
                        if (i + 1 < args.length) {
                            urlEpsg = Long.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: URL EPSG argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "tms": {
                        tms = true;
                        break;
                    }
                    case "replace": {
                        replaceExisting = true;
                        break;
                    }
                    case "logCount": {
                        if (i + 1 < args.length) {
                            progress.setCountFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Count argument '" + arg + "' must be followed by a frequency count value");
                        break;
                    }
                    case "logTime": {
                        if (i + 1 < args.length) {
                            progress.setTimeFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Time argument '" + arg + "' must be followed by a frequency time value in seconds");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (geoPackageFile == null) {
                geoPackageFile = new File(arg);
                continue;
            }
            if (tileTable == null) {
                tileTable = arg;
                continue;
            }
            if (url == null) {
                url = arg;
                continue;
            }
            if (zoomValue == null) {
                zoomValue = arg;
                requiredArguments = true;
                continue;
            }
            if (maxZoom == null) {
                maxZoom = Integer.valueOf(arg);
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (zoomValue != null) {
            if (maxZoom != null) {
                zoomValue = zoomValue + ARGUMENT_PREFIX + maxZoom;
            }
            if ((zoomLevels = TileReproject.parseZoomLevels(zoomValue)) == null) {
                System.out.println("Error: Invalid zoom level(s) or range: " + zoomValue);
                valid = false;
            }
        }
        if (compressFormat == null && compressQuality != null) {
            System.out.println("Error: Compress quality requires a compress format");
            valid = false;
        } else if (boundingBox == null && epsg != null) {
            System.out.println("Error: EPSG requires a bounding box");
            valid = false;
        }
        if (!valid || !requiredArguments) {
            URLTileGen.printUsage();
        } else {
            try {
                URLTileGen.generate();
            }
            catch (Exception e) {
                URLTileGen.printUsage();
                throw e;
            }
        }
    }

    public static void generate() {
        if (!geoPackageFile.exists()) {
            GeoPackageManager.create(geoPackageFile);
        }
        geoPackage = GeoPackageManager.open(geoPackageFile);
        if (epsg == null) {
            epsg = 4326L;
        }
        Projection bboxProjection = null;
        if (boundingBox != null) {
            bboxProjection = ProjectionFactory.getProjection((long)epsg);
        } else {
            boundingBox = BoundingBox.worldWGS84();
            bboxProjection = ProjectionFactory.getProjection((long)4326L);
        }
        if (bboxProjection.isUnit(Units.DEGREES)) {
            boundingBox = TileBoundingBoxUtils.boundDegreesBoundingBoxWithWebMercatorLimits((BoundingBox)boundingBox);
        }
        Projection urlProjection = ProjectionFactory.getProjection((long)urlEpsg);
        GeometryTransform transform = GeometryTransform.create((Projection)bboxProjection, (Projection)urlProjection);
        BoundingBox urlBoundingBox = boundingBox.transform(transform);
        UrlTileGenerator tileGenerator = new UrlTileGenerator(geoPackage, tileTable, url, urlBoundingBox, urlProjection);
        for (long zoomLevel : zoomLevels) {
            tileGenerator.addZoomLevel((int)zoomLevel);
        }
        if (compressFormat != null) {
            tileGenerator.setCompressFormat(compressFormat);
            if (compressQuality != null) {
                tileGenerator.setCompressQuality(compressQuality);
            }
        }
        if (xyzTiles) {
            tileGenerator.setXYZTiles(true);
        }
        if (tms) {
            tileGenerator.setTileFormat(TileFormatType.TMS);
        }
        tileGenerator.setSkipExisting(!replaceExisting);
        int count = tileGenerator.getTileCount();
        System.out.println();
        System.out.println("GeoPackage: " + geoPackage.getName());
        System.out.println("Tile Table: " + tileTable);
        System.out.println("URL: " + url);
        System.out.println("Zoom Levels: " + zoomLevels);
        if (compressFormat != null) {
            System.out.println("Compress Format: " + compressFormat);
        }
        if (compressQuality != null) {
            System.out.println("Compress Quality: " + compressQuality);
        }
        if (xyzTiles) {
            System.out.println("Save as XYZ Tiles: true");
        }
        if (boundingBox != null) {
            System.out.println("Bounding Box:");
            System.out.println("\tMin Lon: " + boundingBox.getMinLongitude());
            System.out.println("\tMin Lat: " + boundingBox.getMinLatitude());
            System.out.println("\tMax Lon: " + boundingBox.getMaxLongitude());
            System.out.println("\tMax Lat: " + boundingBox.getMaxLatitude());
        }
        if (epsg != null) {
            System.out.println("EPSG: " + epsg);
        }
        System.out.println("URL EPSG: " + urlEpsg);
        if (tms) {
            System.out.println("URL TMS Tiles: true");
        }
        System.out.println("Existing Tiles: " + (replaceExisting ? ARGUMENT_REPLACE_EXISTING : "skip"));
        System.out.println("Log Count Frequency: " + progress.getCountFrequency() + " tiles");
        System.out.println("Log Time Frequency: " + progress.getTimeFrequency() + " seconds");
        System.out.println("Expected Tile Count: " + count);
        System.out.println();
        tileGenerator.setProgress(progress);
        LOGGER.log(Level.INFO, "Generating Tiles...");
        int generatedCount = 0;
        try {
            generatedCount = tileGenerator.generateTiles();
        }
        catch (IOException | SQLException e) {
            throw new GeoPackageException("Exception while generating tiles", (Throwable)e);
        }
        URLTileGen.finish(generatedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finish(int count) {
        if (progress.getMax() != null) {
            StringBuilder output = new StringBuilder();
            int progressCount = progress.getProgress();
            output.append("\nTile Generation: ").append(progressCount).append(" of ").append(progress.getMax()).append(" tiles");
            if (count != progressCount) {
                output.append(" (").append(count).append(" new, ").append(progressCount - count).append(" skipped)");
            }
            if (geoPackage != null) {
                try {
                    GeoPackageTextOutput textOutput = new GeoPackageTextOutput(geoPackage);
                    output.append("\n\n");
                    output.append(textOutput.header());
                    output.append("\n\n");
                    output.append(textOutput.tileTable(tileTable));
                }
                finally {
                    geoPackage.close();
                }
            }
            output.append("\n");
            System.out.println(output.toString());
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-f compress_format] [-q compress_quality] [-xyz] [-bbox minLon,minLat,maxLon,maxLat] [-epsg epsg] [-uepsg url_epsg] [-tms] [-replace] [-logCount count] [-logTime time] geopackage_file tile_table url zoom_levels");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tGenerates tiles into a GeoPackage tile table by requesting them from a URL");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-f compress_format");
        System.out.println("\t\tTile compression image format: png, jpg, jpeg (default is no compression, native format)");
        System.out.println();
        System.out.println("\t-q compress_quality");
        System.out.println("\t\tTile compression image quality between 0.0 and 1.0 (not valid for png, default is 1.0)");
        System.out.println();
        System.out.println("\t-xyz");
        System.out.println("\t\tGenerate tiles in XYZ tile format (default is GeoPackage format with minimum bounds)");
        System.out.println();
        System.out.println("\t-bbox minLon,minLat,maxLon,maxLat");
        System.out.println("\t\tOnly tiles overlapping the bounding box are requested (default is the world)");
        System.out.println();
        System.out.println("\t-epsg epsg");
        System.out.println("\t\tEPSG number of the provided bounding box (default is 4326, WGS 84)");
        System.out.println();
        System.out.println("\t-uepsg url_epsg");
        System.out.println("\t\tEPSG number of the tiles provided by the URL (default is 3857, Web Mercator");
        System.out.println();
        System.out.println("\t-tms");
        System.out.println("\t\tRequest URL for x,y,z coordinates is in TMS format (default is standard XYZ)");
        System.out.println();
        System.out.println("\t-replace");
        System.out.println("\t\tReplace tiles when updating an existing GeoPackage with new requested tiles (default is to skip existing tiles)");
        System.out.println();
        System.out.println("\t-logCount count");
        System.out.println("\t\tLog frequency count of generated tiles (default is 100)");
        System.out.println();
        System.out.println("\t-logTime time");
        System.out.println("\t\tLog frequency time in seconds (default is 60)");
        System.out.println();
        System.out.println("\tgeopackage_file");
        System.out.println("\t\tpath to the GeoPackage file to create, or existing file to update");
        System.out.println();
        System.out.println("\ttile_table");
        System.out.println("\t\ttile table name within the GeoPackage file to create or update");
        System.out.println();
        System.out.println("\turl");
        System.out.println("\t\tURL with substitution variables for requesting tiles");
        System.out.println();
        System.out.println("\t\t{z}");
        System.out.println("\t\t\tz URL substitution variable for zoom level");
        System.out.println();
        System.out.println("\t\t{x}");
        System.out.println("\t\t\tx URL substitution variable");
        System.out.println();
        System.out.println("\t\t{y}");
        System.out.println("\t\t\ty URL substitution variable");
        System.out.println();
        System.out.println("\t\t{minLon}");
        System.out.println("\t\t\tMinimum longitude URL substitution variable");
        System.out.println();
        System.out.println("\t\t{minLat}");
        System.out.println("\t\t\tMinimum latitude URL substitution variable");
        System.out.println();
        System.out.println("\t\t{maxLon}");
        System.out.println("\t\t\tMaximum longitude URL substitution variable");
        System.out.println();
        System.out.println("\t\t{maxLat}");
        System.out.println("\t\t\tMaximum latitude URL substitution variable");
        System.out.println();
        System.out.println("\tzoom_levels");
        System.out.println("\t\tZoom levels to request tiles for, specified as 'z', 'zmin-zmax', 'z1,z2,...', or 'zmin zmax'");
        System.out.println();
    }
}

