/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariDataSource;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.database.PostgresUtils;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.DefaultObjectMapper;
import org.apache.baremaps.server.DevResources;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dev", description={"Start a development server with live reload."})
public class Dev
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Dev.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of Postgres."}, required=true)
    private String database;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tileset;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path style;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        try (final HikariDataSource dataSource = PostgresUtils.dataSource((String)this.database);){
            final ObjectMapper objectMapper = DefaultObjectMapper.defaultObjectMapper();
            ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(DevResources.class).register((Object)ServiceTalkJacksonSerializerFeature.contextResolverFor((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind("viewer").to(String.class).named("assets");
                    this.bind(Dev.this.tileset.toAbsolutePath()).to(Path.class).named("tileset");
                    this.bind(Dev.this.style.toAbsolutePath()).to(Path.class).named("style");
                    this.bind(dataSource).to(DataSource.class);
                    this.bind(objectMapper).to(ObjectMapper.class);
                }
            });
            BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
            HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
            logger.info("Listening on {}", (Object)serverContext.listenAddress());
            serverContext.awaitShutdown();
        }
        return 0;
    }
}

