/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api.internal;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class BlockingUtils {
    private BlockingUtils() {
    }

    public static <T> T futureGetCancelOnInterrupt(Future<T> future) throws Exception {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.cancel(false);
            throw e;
        }
        catch (ExecutionException e) {
            return (T)PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    public static <T> T blockingInvocation(Single<T> source) throws Exception {
        try {
            return (T)source.toFuture().get();
        }
        catch (ExecutionException e) {
            return (T)PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    public static void blockingInvocation(Completable source) throws Exception {
        try {
            source.toFuture().get();
        }
        catch (ExecutionException e) {
            PlatformDependent.throwException((Throwable)BlockingUtils.executionExceptionCause(e));
        }
    }

    private static Throwable executionExceptionCause(ExecutionException original) {
        return original.getCause() != null ? original.getCause() : original;
    }
}

