/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.baremaps.api.StylesApi;
import org.apache.baremaps.model.Link;
import org.apache.baremaps.model.MbStyle;
import org.apache.baremaps.model.StyleSet;
import org.apache.baremaps.model.StyleSetEntry;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;

@Singleton
public class StylesResource
implements StylesApi {
    private static final QualifiedType<MbStyle> MBSTYLE = QualifiedType.of(MbStyle.class).with(new Class[]{Json.class});
    private final Jdbi jdbi;
    @Context
    UriInfo uriInfo;

    @Inject
    public StylesResource(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    @Override
    public Response addStyle(MbStyle mbStyle) {
        UUID styleId = UUID.randomUUID();
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("insert into styles (id, style) values (:id, CAST(:json AS jsonb))").bindByType("json", (Object)mbStyle, MBSTYLE)).bind("id", styleId)).execute());
        return Response.created((URI)URI.create("styles/" + styleId)).build();
    }

    @Override
    public Response deleteStyle(UUID styleId) {
        this.jdbi.useHandle(handle -> handle.execute("delete from styles where id = (?)", new Object[]{styleId}));
        return Response.noContent().build();
    }

    @Override
    public Response getStyle(UUID styleId) {
        MbStyle style = (MbStyle)this.jdbi.withHandle(handle -> (MbStyle)((Query)handle.createQuery("select style from styles where id = :id").bind("id", styleId)).mapTo(MBSTYLE).one());
        return Response.ok((Object)style).build();
    }

    @Override
    public Response getStyleSet() {
        List ids = (List)this.jdbi.withHandle(handle -> handle.createQuery("select id from styles").mapTo(UUID.class).list());
        StyleSet styleSet = new StyleSet();
        ArrayList<StyleSetEntry> entries = new ArrayList<StyleSetEntry>();
        String address = this.uriInfo.getRequestUri().toString();
        for (UUID id : ids) {
            Link link = new Link();
            link.setHref(address + id);
            link.setType("application/vnd.mapbox.style+json");
            link.setRel("stylesheet");
            StyleSetEntry entry = new StyleSetEntry();
            entry.setId(id);
            entry.setLinks(List.of(link));
            entries.add(entry);
        }
        styleSet.setStyles(entries);
        return Response.ok((Object)styleSet).build();
    }

    @Override
    public Response updateStyle(UUID styleId, MbStyle mbStyle) {
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("update styles set style = :json where id = :id").bindByType("json", (Object)mbStyle, MBSTYLE)).bind("id", styleId)).execute());
        return Response.noContent().build();
    }
}

