/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DurationUtils {
    private static final Duration LONG_MAX_NANOS = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration LONG_MIN_NANOS = Duration.ofNanos(Long.MIN_VALUE);

    private DurationUtils() {
    }

    public static boolean isPositive(Duration duration) {
        return Duration.ZERO.compareTo(duration) < 0;
    }

    public static Duration ensurePositive(Duration duration, String name) {
        if (!DurationUtils.isPositive(Objects.requireNonNull(duration, name))) {
            throw new IllegalArgumentException(name + ": " + duration + " (expected > 0)");
        }
        return duration;
    }

    public static boolean isInfinite(@Nullable Duration duration, Duration maxDuration) {
        return duration == null || maxDuration.compareTo(duration) < 0;
    }

    public static long toNanos(Duration duration) {
        return duration.compareTo(LONG_MAX_NANOS) < 0 ? (duration.compareTo(LONG_MIN_NANOS) > 0 ? duration.toNanos() : Long.MIN_VALUE) : Long.MAX_VALUE;
    }
}

