/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite3.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.IndexIdAndTableVersion;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.ReadOnlyIndexInfo;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

public class FullStateTransferIndexChooser
implements ManuallyCloseable {
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;
    private final NavigableSet<ReadOnlyIndexInfo> readOnlyIndexes = new ConcurrentSkipListSet<ReadOnlyIndexInfo>(Comparator.comparingInt(ReadOnlyIndexInfo::tableId).thenComparingLong(ReadOnlyIndexInfo::activationTs).thenComparingInt(ReadOnlyIndexInfo::indexId));
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private final IndexMetaStorage indexMetaStorage;

    public FullStateTransferIndexChooser(CatalogService catalogService, LowWatermark lowWatermark, IndexMetaStorage indexMetaStorage) {
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
        this.indexMetaStorage = indexMetaStorage;
    }

    public void start() {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            this.addListenersBusy();
            this.recoverStructuresBusy();
        });
    }

    @Override
    public void close() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.readOnlyIndexes.clear();
    }

    public List<IndexIdAndTableVersion> chooseForAddWrite(int catalogVersion, int tableId, HybridTimestamp beginTs) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> {
            Catalog catalog = this.catalogService.activeCatalog(beginTs.longValue());
            List<Integer> fromCatalog = this.chooseFromCatalogBusy(catalogVersion, tableId, index -> {
                if (index.status() == CatalogIndexStatus.REGISTERED) {
                    CatalogIndexDescriptor indexAtBeginTs = catalog.index(index.id());
                    return indexAtBeginTs != null && indexAtBeginTs.status() == CatalogIndexStatus.REGISTERED;
                }
                return true;
            });
            List<Integer> fromReadOnlyIndexes = this.chooseFromReadOnlyIndexesBusy(tableId, beginTs);
            return this.enrichWithTableVersions(FullStateTransferIndexChooser.mergeWithoutDuplicates(fromCatalog, fromReadOnlyIndexes));
        });
    }

    public List<IndexIdAndTableVersion> chooseForAddWriteCommitted(int catalogVersion, int tableId, HybridTimestamp commitTs) {
        return IgniteUtils.inBusyLock(this.busyLock, () -> {
            List<Integer> fromCatalog = this.chooseFromCatalogBusy(catalogVersion, tableId, index -> index.status() != CatalogIndexStatus.REGISTERED);
            List<Integer> fromReadOnlyIndexes = this.chooseFromReadOnlyIndexesBusy(tableId, commitTs);
            return this.enrichWithTableVersions(FullStateTransferIndexChooser.mergeWithoutDuplicates(fromCatalog, fromReadOnlyIndexes));
        });
    }

    private List<Integer> chooseFromCatalogBusy(int catalogVersion, int tableId, Predicate<CatalogIndexDescriptor> filter) {
        List<CatalogIndexDescriptor> indexes = this.catalogService.catalog(catalogVersion).indexes(tableId);
        if (indexes.isEmpty()) {
            return List.of();
        }
        ArrayList<CatalogIndexDescriptor> result = new ArrayList<CatalogIndexDescriptor>(indexes.size());
        block3: for (CatalogIndexDescriptor index : indexes) {
            switch (index.status()) {
                case REGISTERED: 
                case BUILDING: 
                case AVAILABLE: 
                case STOPPING: {
                    if (!filter.test(index)) continue block3;
                    result.add(index);
                    continue block3;
                }
            }
            throw new IllegalStateException("Unknown index status: " + index.status());
        }
        return CollectionUtils.view(result, CatalogObjectDescriptor::id);
    }

    private List<Integer> chooseFromReadOnlyIndexesBusy(int tableId, HybridTimestamp fromTsExcluded) {
        ReadOnlyIndexInfo toKeyExcluded;
        ReadOnlyIndexInfo fromKeyIncluded = new ReadOnlyIndexInfo(tableId, fromTsExcluded.longValue() + 1L, 0, 0);
        NavigableSet<ReadOnlyIndexInfo> subSet = this.readOnlyIndexes.subSet(fromKeyIncluded, true, toKeyExcluded = new ReadOnlyIndexInfo(tableId + 1, 0L, 0, 0), false);
        if (subSet.isEmpty()) {
            return List.of();
        }
        return subSet.stream().map(ReadOnlyIndexInfo::indexId).sorted().collect(Collectors.toList());
    }

    private static List<Integer> mergeWithoutDuplicates(List<Integer> l0, List<Integer> l1) {
        if (l0.isEmpty()) {
            return l1;
        }
        if (l1.isEmpty()) {
            return l0;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(l0.size() + l1.size());
        int i0 = 0;
        int i1 = 0;
        while (i0 < l0.size() || i1 < l1.size()) {
            if (i0 >= l0.size()) {
                result.add(l1.get(i1++));
                continue;
            }
            if (i1 >= l1.size()) {
                result.add(l0.get(i0++));
                continue;
            }
            Integer indexId0 = l0.get(i0);
            Integer indexId1 = l1.get(i1);
            if (indexId0 < indexId1) {
                result.add(indexId0);
                ++i0;
                continue;
            }
            if (indexId0 > indexId1) {
                result.add(indexId1);
                ++i1;
                continue;
            }
            result.add(indexId0);
            ++i0;
            ++i1;
        }
        return result;
    }

    private void addListenersBusy() {
        this.catalogService.listen(CatalogEvent.INDEX_REMOVED, EventListener.fromConsumer(this::onIndexRemoved));
        this.lowWatermark.listen(LowWatermarkEvent.LOW_WATERMARK_CHANGED, EventListener.fromConsumer(this::onLwmChanged));
    }

    private void onIndexRemoved(RemoveIndexEventParameters parameters) {
        IgniteUtils.inBusyLock(this.busyLock, () -> {
            int indexId = parameters.indexId();
            int catalogVersion = parameters.catalogVersion();
            this.lowWatermark.getLowWatermarkSafe(lwm -> {
                int lwmCatalogVersion;
                int n = lwmCatalogVersion = lwm == null ? this.catalogService.earliestCatalogVersion() : this.catalogService.activeCatalogVersion(lwm.longValue());
                if (catalogVersion <= lwmCatalogVersion) {
                    return;
                }
                IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexId);
                assert (indexMeta != null) : "indexId=" + indexId + ", catalogVersion=" + catalogVersion;
                if (indexMeta.status() == MetaIndexStatus.READ_ONLY) {
                    this.readOnlyIndexes.add(FullStateTransferIndexChooser.toReadOnlyIndexInfo(indexMeta));
                }
            });
        });
    }

    private void recoverStructuresBusy() {
        this.indexMetaStorage.indexMetas().stream().filter(indexMeta -> indexMeta.status() == MetaIndexStatus.READ_ONLY).map(FullStateTransferIndexChooser::toReadOnlyIndexInfo).forEach(this.readOnlyIndexes::add);
    }

    private List<IndexIdAndTableVersion> enrichWithTableVersions(List<Integer> indexIds) {
        return indexIds.stream().map(indexId -> {
            IndexMeta indexMeta = this.indexMetaStorage.indexMeta((int)indexId);
            if (indexMeta == null || indexMeta.status() == MetaIndexStatus.REMOVED) {
                return null;
            }
            return new IndexIdAndTableVersion((int)indexId, indexMeta.tableVersion());
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(indexIds.size())));
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            int lwmCatalogVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
            this.readOnlyIndexes.removeIf(readOnlyIndexInfo -> readOnlyIndexInfo.indexRemovalCatalogVersion() <= lwmCatalogVersion);
        });
    }

    private static long activationTs(IndexMeta indexMeta, MetaIndexStatus status) {
        return indexMeta.statusChange(status).activationTimestamp();
    }

    private static ReadOnlyIndexInfo toReadOnlyIndexInfo(IndexMeta indexMeta) {
        assert (indexMeta.status() == MetaIndexStatus.READ_ONLY) : "indexId=" + indexMeta.indexId() + ", status=" + indexMeta.status();
        long activationTs = indexMeta.statusChanges().containsKey((Object)MetaIndexStatus.STOPPING) ? FullStateTransferIndexChooser.activationTs(indexMeta, MetaIndexStatus.STOPPING) : FullStateTransferIndexChooser.activationTs(indexMeta, MetaIndexStatus.READ_ONLY);
        return new ReadOnlyIndexInfo(indexMeta.tableId(), activationTs, indexMeta.indexId(), indexMeta.statusChange(MetaIndexStatus.READ_ONLY).catalogVersion());
    }
}

