/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.NoSuchElementException;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

class ScanVersionsCursor
implements Cursor<ReadResult> {
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final VersionChain versionChain;
    @Nullable
    private Boolean hasNext;
    private RowVersion currentRowVersion;
    private long nextLink;

    ScanVersionsCursor(VersionChain versionChain, AbstractPageMemoryMvPartitionStorage storage) {
        this.storage = storage;
        this.versionChain = versionChain;
        this.nextLink = versionChain.headLink();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            if (this.hasNext != null) {
                return this.hasNext;
            }
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(this.versionChain.rowId()));
            this.hasNext = this.nextLink != 0L;
            if (this.hasNext.booleanValue()) {
                this.currentRowVersion = this.storage.readRowVersion(this.nextLink, AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
                this.nextLink = this.currentRowVersion.nextLink();
            }
            return this.hasNext;
        });
    }

    @Override
    public ReadResult next() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(this.versionChain.rowId()));
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.rowVersionToReadResult(this.currentRowVersion);
        });
    }

    private ReadResult rowVersionToReadResult(RowVersion rowVersion) {
        RowId rowId = this.versionChain.rowId();
        if (rowVersion.isCommitted()) {
            if (rowVersion.isTombstone()) {
                return ReadResult.empty(rowId);
            }
            return ReadResult.createFromCommitted(rowId, rowVersion.value(), rowVersion.timestamp());
        }
        return ReadResult.createFromWriteIntent(rowId, rowVersion.value(), this.versionChain.transactionId(), this.versionChain.commitTableId(), this.versionChain.commitPartitionId(), null);
    }
}

