/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.hash.io;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.tree.io.BplusLeafIo;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite3.internal.storage.pagememory.index.hash.io.HashIndexTreeIo;

public class HashIndexTreeLeafIo
extends BplusLeafIo<HashIndexRowKey>
implements HashIndexTreeIo {
    public static final List<IoVersions<HashIndexTreeLeafIo>> VERSIONS = IntStream.rangeClosed(0, 2048).mapToObj(inlineSize -> new IoVersions((PageIo[])new HashIndexTreeLeafIo[]{new HashIndexTreeLeafIo(1, inlineSize)})).collect(Collectors.toUnmodifiableList());

    private HashIndexTreeLeafIo(int ver, int inlineSize) {
        super(15000 + inlineSize, ver, 28 + inlineSize);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<HashIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        HashIndexTreeIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, HashIndexRowKey row) {
        HashIndexTreeIo.super.storeByOffset(pageAddr, off, row);
    }

    @Override
    public HashIndexRowKey getLookupRow(BplusTree<HashIndexRowKey, ?> tree, long pageAddr, int idx) throws IgniteInternalCheckedException {
        HashIndexTree hashIndexTree = (HashIndexTree)tree;
        return this.getRow(hashIndexTree.dataPageReader(), hashIndexTree.partitionId(), pageAddr, idx);
    }

    @Override
    public void visit(BplusTree<HashIndexRowKey, ?> tree, long pageAddr, Consumer<HashIndexRowKey> c) {
        HashIndexTree hashIndexTree = (HashIndexTree)tree;
        int count = this.getCount(pageAddr);
        for (int i = 0; i < count; ++i) {
            HashIndexRow indexRow;
            try {
                indexRow = this.getRow(hashIndexTree.dataPageReader(), hashIndexTree.partitionId(), pageAddr, i);
            }
            catch (IgniteInternalCheckedException e) {
                throw new IgniteInternalException(e);
            }
            c.accept(indexRow);
        }
    }
}

