/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.binarytuple.BinaryTupleCommon;
import org.apache.ignite3.internal.binarytuple.BinaryTuplePrefixBuilder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.lang.InternalTuple;
import org.apache.ignite3.internal.schema.BinaryTuple;

public class BinaryTuplePrefix
extends BinaryTupleReader
implements InternalTuple {
    public BinaryTuplePrefix(int elementCount, byte[] bytes) {
        super(elementCount, bytes);
    }

    public BinaryTuplePrefix(int elementCount, ByteBuffer buffer) {
        super(elementCount, buffer);
    }

    public static BinaryTuplePrefix fromBinaryTuple(int numElements, BinaryTuple tuple) {
        if (numElements == tuple.elementCount()) {
            return BinaryTuplePrefix.entireTuple(tuple);
        }
        if (numElements > tuple.elementCount()) {
            return BinaryTuplePrefix.expandTuple(numElements, tuple);
        }
        return BinaryTuplePrefix.truncateTuple(numElements, tuple);
    }

    public static BinaryTuplePrefix fromBinaryTuple(BinaryTuple tuple) {
        return BinaryTuplePrefix.entireTuple(tuple);
    }

    private static BinaryTuplePrefix entireTuple(BinaryTuple tuple) {
        ByteBuffer tupleBuffer = tuple.byteBuffer();
        ByteBuffer prefixBuffer = ByteBuffer.allocate(tupleBuffer.remaining() + 4).order(ORDER).put(tupleBuffer).putInt(tuple.elementCount()).flip();
        byte flags = prefixBuffer.get(0);
        prefixBuffer.put(0, (byte)(flags | 8));
        return new BinaryTuplePrefix(tuple.elementCount(), prefixBuffer);
    }

    private static BinaryTuplePrefix expandTuple(int numElements, BinaryTuple tuple) {
        assert (numElements > tuple.elementCount());
        if (tuple.elementCount() == 0) {
            return new BinaryTuplePrefix(numElements, new BinaryTuplePrefixBuilder(0, numElements, 0).build());
        }
        int[] dataBeginOffsetHolder = new int[1];
        int[] dataEndOffsetHolder = new int[1];
        tuple.fetch(0, (index, begin, end) -> {
            dataBeginOffsetHolder[0] = begin;
        });
        tuple.fetch(tuple.elementCount() - 1, (index, begin, end) -> {
            dataEndOffsetHolder[0] = end;
        });
        ByteBuffer tupleBuffer = tuple.byteBuffer();
        byte flags = tupleBuffer.get(0);
        int entrySize = BinaryTupleCommon.flagsToEntrySize(flags);
        int newTupleSize = tupleBuffer.remaining() + entrySize * (numElements - tuple.elementCount()) + 4;
        ByteBuffer prefixBuffer = ByteBuffer.allocate(newTupleSize).order(ORDER).put(tupleBuffer.duplicate().limit(dataBeginOffsetHolder[0]));
        int payloadEndPosition = dataEndOffsetHolder[0] - dataBeginOffsetHolder[0];
        block5: for (int idx = tuple.elementCount(); idx < numElements; ++idx) {
            switch (entrySize) {
                case 1: {
                    prefixBuffer.put((byte)payloadEndPosition);
                    continue block5;
                }
                case 2: {
                    prefixBuffer.putShort((short)payloadEndPosition);
                    continue block5;
                }
                case 4: {
                    prefixBuffer.putInt(payloadEndPosition);
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        prefixBuffer.put(tupleBuffer.slice().position(dataBeginOffsetHolder[0]).limit(dataEndOffsetHolder[0])).putInt(tuple.elementCount()).flip();
        prefixBuffer.put(0, (byte)(flags | 8));
        return new BinaryTuplePrefix(numElements, prefixBuffer);
    }

    private static BinaryTuplePrefix truncateTuple(int numElements, BinaryTuple tuple) {
        assert (numElements < tuple.elementCount());
        int[] dataBeginOffsetHolder = new int[1];
        int[] dataEndOffsetHolder = new int[1];
        tuple.fetch(0, (index, begin, end) -> {
            dataBeginOffsetHolder[0] = begin;
        });
        tuple.fetch(numElements - 1, (index, begin, end) -> {
            dataEndOffsetHolder[0] = end;
        });
        BinaryTuplePrefixBuilder builder = new BinaryTuplePrefixBuilder(numElements, numElements, dataEndOffsetHolder[0] - dataBeginOffsetHolder[0]);
        for (int i = 0; i < numElements; ++i) {
            byte[] valueBytes = tuple.bytesValue(i);
            builder.appendBytes(valueBytes);
        }
        return new BinaryTuplePrefix(numElements, builder.build());
    }

    @Override
    public int elementCount() {
        ByteBuffer buffer = this.byteBuffer();
        return buffer.getInt(buffer.limit() - 4);
    }
}

