/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.error.code.generators;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.ignite3.internal.error.code.generators.AbstractCodeGenerator;
import org.apache.ignite3.internal.error.code.processor.ErrorCodeGroupDescriptor;
import org.apache.ignite3.internal.error.code.processor.ErrorCodeGroupProcessorException;

public abstract class GenericGenerator
implements AbstractCodeGenerator {
    final ProcessingEnvironment processingEnvironment;
    final String outFilePath;
    BufferedWriter writer;
    static final int groupShift = 16;

    protected void line(String str) throws IOException {
        this.writer.write(str);
        this.writer.newLine();
    }

    protected void line() throws IOException {
        this.line("");
    }

    GenericGenerator(ProcessingEnvironment processingEnvironment, String outFilePath) {
        this.processingEnvironment = processingEnvironment;
        this.outFilePath = outFilePath;
    }

    void generateFile(List<ErrorCodeGroupDescriptor> descriptors) throws IOException, ErrorCodeGroupProcessorException {
        throw new ErrorCodeGroupProcessorException("generateFile not implemented!");
    }

    void generateLicense() throws IOException {
        this.line("/*");
        this.line(" * Licensed to the Apache Software Foundation (ASF) under one or more");
        this.line(" * contributor license agreements. See the NOTICE file distributed with");
        this.line(" * this work for additional information regarding copyright ownership.");
        this.line(" * The ASF licenses this file to You under the Apache License, Version 2.0");
        this.line(" * (the \"License\"); you may not use this file except in compliance with");
        this.line(" * the License. You may obtain a copy of the License at");
        this.line(" *");
        this.line(" *      http://www.apache.org/licenses/LICENSE-2.0");
        this.line(" *");
        this.line(" * Unless required by applicable law or agreed to in writing, software");
        this.line(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
        this.line(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        this.line(" * See the License for the specific language governing permissions and");
        this.line(" * limitations under the License.");
        this.line(" */");
        this.line();
    }

    @Override
    public void generate(List<ErrorCodeGroupDescriptor> descriptors) {
        try {
            FileObject resource = this.processingEnvironment.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", this.outFilePath, new Element[0]);
            this.writer = new BufferedWriter(resource.openWriter());
            this.generateLicense();
            this.generateFile(descriptors);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ErrorCodeGroupProcessorException("IO exception during annotation processing", e);
        }
    }
}

