/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.systemviews;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.SubscriptionUtils;

public class SystemViewViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        SystemView<?> systemViewsView = SystemViewViewProvider.getSystemViewView(catalogSupplier);
        SystemView<?> systemViewColumnsView = SystemViewViewProvider.getSystemViewColumnsView(catalogSupplier);
        return List.of(systemViewsView, systemViewColumnsView);
    }

    private static SystemView<?> getSystemViewView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().flatMap(schema -> Arrays.stream(schema.systemViews()).map(viewDescriptor -> new ViewWithSchema((CatalogSystemViewDescriptor)viewDescriptor, schema.name()))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SYSTEM_VIEWS")).addColumn("VIEW_ID", NativeTypes.INT32, entry -> entry.descriptor.id())).addColumn("SCHEMA_NAME", NativeTypes.STRING, entry -> entry.schema)).addColumn("VIEW_NAME", NativeTypes.STRING, entry -> entry.descriptor.name())).addColumn("VIEW_TYPE", NativeTypes.STRING, entry -> entry.descriptor.systemViewType().name())).addColumn("ID", NativeTypes.INT32, entry -> entry.descriptor.id())).addColumn("SCHEMA", NativeTypes.STRING, entry -> entry.schema)).addColumn("NAME", NativeTypes.STRING, entry -> entry.descriptor.name())).addColumn("TYPE", NativeTypes.STRING, entry -> entry.descriptor.systemViewType().name())).dataProvider(viewDataPublisher)).build();
    }

    private static SystemView<?> getSystemViewColumnsView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().flatMap(schema -> Arrays.stream(schema.systemViews())).flatMap(viewDescriptor -> viewDescriptor.columns().stream().map(columnDescriptor -> new ColumnWithTableId((CatalogTableColumnDescriptor)columnDescriptor, viewDescriptor.id()))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SYSTEM_VIEW_COLUMNS")).addColumn("VIEW_ID", NativeTypes.INT32, entry -> entry.id)).addColumn("VIEW_NAME", NativeTypes.STRING, entry -> entry.descriptor.name())).addColumn("COLUMN_TYPE", NativeTypes.STRING, entry -> entry.descriptor.type().name())).addColumn("IS_NULLABLE_COLUMN", NativeTypes.BOOLEAN, entry -> entry.descriptor.nullable())).addColumn("COLUMN_PRECISION", NativeTypes.INT32, entry -> entry.descriptor.precision())).addColumn("COLUMN_SCALE", NativeTypes.INT32, entry -> entry.descriptor.scale())).addColumn("COLUMN_LENGTH", NativeTypes.INT32, entry -> entry.descriptor.length())).addColumn("NAME", NativeTypes.STRING, entry -> entry.descriptor.name())).addColumn("TYPE", NativeTypes.STRING, entry -> entry.descriptor.type().name())).addColumn("NULLABLE", NativeTypes.BOOLEAN, entry -> entry.descriptor.nullable())).addColumn("PRECISION", NativeTypes.INT32, entry -> entry.descriptor.precision())).addColumn("SCALE", NativeTypes.INT32, entry -> entry.descriptor.scale())).addColumn("LENGTH", NativeTypes.INT32, entry -> entry.descriptor.length())).dataProvider(viewDataPublisher)).build();
    }

    private static class ColumnWithTableId {
        final CatalogTableColumnDescriptor descriptor;
        final int id;

        ColumnWithTableId(CatalogTableColumnDescriptor descriptor, int id) {
            this.descriptor = descriptor;
            this.id = id;
        }
    }

    private static class ViewWithSchema {
        final CatalogSystemViewDescriptor descriptor;
        final String schema;

        ViewWithSchema(CatalogSystemViewDescriptor descriptor, String schema) {
            this.descriptor = descriptor;
            this.schema = schema;
        }
    }
}

