/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.UUID;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;

public class SqlKillScanQueryCommand
implements SqlCommand {
    public static final String KILL_SCAN_QRY_FORMAT = "Format of the query is KILL SCAN '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' 'cache-name' 1";
    private UUID originNodeId;
    private String cacheName;
    private long qryId;

    public SqlKillScanQueryCommand() {
    }

    public SqlKillScanQueryCommand(UUID originNodeId, String cacheName, long qryId) {
        this.originNodeId = originNodeId;
        this.cacheName = cacheName;
        this.qryId = qryId;
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
            this.originNodeId = UUID.fromString(lex.token());
            if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
                this.cacheName = lex.token();
                if (!lex.shift() || lex.tokenType() != SqlLexerTokenType.DEFAULT) {
                    throw SqlParserUtils.error(lex, "Expected query id. Format of the query is KILL SCAN '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' 'cache-name' 1");
                }
            } else {
                throw SqlParserUtils.error(lex, "Expected cache name. Format of the query is KILL SCAN '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' 'cache-name' 1");
            }
            this.qryId = Long.parseLong(lex.token());
            return this;
        }
        throw SqlParserUtils.error(lex, "Expected origin node id. Format of the query is KILL SCAN '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' 'cache-name' 1");
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
    }

    public UUID getOriginNodeId() {
        return this.originNodeId;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public long getQryId() {
        return this.qryId;
    }
}

