/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.SystemViewCommandArg;
import org.apache.ignite.internal.management.SystemViewTaskResult;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class SystemViewTask
extends VisorMultiNodeTask<SystemViewCommandArg, SystemViewTaskResult, SystemViewTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<SystemViewCommandArg, SystemViewTaskResult> job(SystemViewCommandArg arg) {
        return new SystemViewJob(arg, false);
    }

    @Override
    @Nullable
    protected SystemViewTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        SystemViewTaskResult res = null;
        TreeMap merged = new TreeMap();
        for (ComputeJobResult r : results) {
            if (r.getException() != null) {
                throw new IgniteException("Failed to execute job [nodeId=" + r.getNode().id() + "]", r.getException());
            }
            res = (SystemViewTaskResult)r.getData();
            if (res == null) {
                return null;
            }
            merged.putAll(res.rows());
        }
        return new SystemViewTaskResult(res.attributes(), res.types(), merged);
    }

    public static enum SimpleType {
        DATE,
        NUMBER,
        STRING;

    }

    private static class SystemViewJob
    extends VisorJob<SystemViewCommandArg, SystemViewTaskResult> {
        private static final long serialVersionUID = 0L;

        protected SystemViewJob(@Nullable SystemViewCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected SystemViewTaskResult run(@Nullable SystemViewCommandArg arg) throws IgniteException {
            if (arg == null) {
                return null;
            }
            SystemView<?> sysView = this.systemView(arg.systemViewName());
            if (sysView == null) {
                return null;
            }
            final ArrayList<String> attrNames = new ArrayList<String>();
            final ArrayList<SimpleType> attrTypes = new ArrayList<SimpleType>();
            sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

                @Override
                public <T> void accept(int idx, String name, Class<T> clazz) {
                    attrNames.add(name);
                    Class<?> wrapperCls = U.box(clazz);
                    if (Number.class.isAssignableFrom(wrapperCls)) {
                        attrTypes.add(SimpleType.NUMBER);
                    } else if (Date.class.isAssignableFrom(wrapperCls)) {
                        attrTypes.add(SimpleType.DATE);
                    } else {
                        attrTypes.add(SimpleType.STRING);
                    }
                }
            });
            ArrayList rows = new ArrayList();
            for (Object row : sysView) {
                final ArrayList attrVals = new ArrayList();
                sysView.walker().visitAll(row, new SystemViewRowAttributeWalker.AttributeWithValueVisitor(){

                    @Override
                    public <T> void accept(int idx, String name, Class<T> clazz, @Nullable T val) {
                        if (clazz.isEnum()) {
                            attrVals.add(val == null ? null : ((Enum)val).name());
                        } else if (Class.class.isAssignableFrom(clazz)) {
                            attrVals.add(val == null ? null : ((Class)val).getName());
                        } else if (Date.class.isAssignableFrom(clazz) || UUID.class.isAssignableFrom(clazz) || IgniteUuid.class.isAssignableFrom(clazz)) {
                            attrVals.add((Serializable)val);
                        } else {
                            attrVals.add(String.valueOf(val));
                        }
                    }

                    @Override
                    public void acceptBoolean(int idx, String name, boolean val) {
                        attrVals.add(val);
                    }

                    @Override
                    public void acceptChar(int idx, String name, char val) {
                        attrVals.add(Character.valueOf(val));
                    }

                    @Override
                    public void acceptByte(int idx, String name, byte val) {
                        attrVals.add(val);
                    }

                    @Override
                    public void acceptShort(int idx, String name, short val) {
                        attrVals.add(val);
                    }

                    @Override
                    public void acceptInt(int idx, String name, int val) {
                        attrVals.add(val);
                    }

                    @Override
                    public void acceptLong(int idx, String name, long val) {
                        attrVals.add(val);
                    }

                    @Override
                    public void acceptFloat(int idx, String name, float val) {
                        attrVals.add(Float.valueOf(val));
                    }

                    @Override
                    public void acceptDouble(int idx, String name, double val) {
                        attrVals.add(val);
                    }
                });
                rows.add(attrVals);
            }
            return new SystemViewTaskResult(attrNames, attrTypes, Collections.singletonMap(this.ignite.localNode().id(), rows));
        }

        private SystemView<?> systemView(String name) {
            GridSystemViewManager sysViewMgr = this.ignite.context().systemView();
            SystemView<Object> res = sysViewMgr.view(name);
            if (res == null) {
                for (SystemView<?> sysView : sysViewMgr) {
                    if (!MetricUtils.toSqlName(sysView.name()).toLowerCase().equals(name.toLowerCase())) continue;
                    res = sysView;
                    break;
                }
            }
            return res;
        }
    }
}

