/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.EvictIdempotentCommandsCacheCommand;
import org.apache.ignite.internal.metastorage.command.EvictIdempotentCommandsCacheCommandBuilder;
import org.apache.ignite.internal.metastorage.command.EvictIdempotentCommandsCacheCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class EvictIdempotentCommandsCacheCommandImpl
implements EvictIdempotentCommandsCacheCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 71;
    @IgniteToStringInclude
    private final HybridTimestamp evictionTimestamp;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private EvictIdempotentCommandsCacheCommandImpl(HybridTimestamp evictionTimestamp, HybridTimestamp initiatorTime, HybridTimestamp safeTime) {
        this.evictionTimestamp = evictionTimestamp;
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp evictionTimestamp() {
        return this.evictionTimestamp;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return EvictIdempotentCommandsCacheCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(EvictIdempotentCommandsCacheCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 71;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EvictIdempotentCommandsCacheCommandImpl otherMessage = (EvictIdempotentCommandsCacheCommandImpl)other;
        return Objects.equals(this.evictionTimestamp, otherMessage.evictionTimestamp) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.evictionTimestamp, this.initiatorTime, this.safeTime);
        return result;
    }

    public EvictIdempotentCommandsCacheCommandImpl clone() {
        try {
            return (EvictIdempotentCommandsCacheCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static EvictIdempotentCommandsCacheCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements EvictIdempotentCommandsCacheCommandBuilder {
        private HybridTimestamp evictionTimestamp;
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public EvictIdempotentCommandsCacheCommandBuilder evictionTimestamp(HybridTimestamp evictionTimestamp) {
            Objects.requireNonNull(evictionTimestamp, "evictionTimestamp is not marked @Nullable");
            this.evictionTimestamp = evictionTimestamp;
            return this;
        }

        @Override
        public EvictIdempotentCommandsCacheCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public EvictIdempotentCommandsCacheCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public HybridTimestamp evictionTimestamp() {
            return this.evictionTimestamp;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public EvictIdempotentCommandsCacheCommand build() {
            return new EvictIdempotentCommandsCacheCommandImpl(Objects.requireNonNull(this.evictionTimestamp, "evictionTimestamp is not marked @Nullable"), Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime);
        }
    }
}

