/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.catalog.definitions;

import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class ColumnDefinition {
    private final String name;
    private final ColumnType<?> type;
    private final String definition;

    private ColumnDefinition(String name, @Nullable ColumnType<?> type, @Nullable String definition) {
        this.name = name;
        this.type = type;
        this.definition = definition;
    }

    public static ColumnDefinition column(String name, ColumnType<?> type) {
        Objects.requireNonNull(name, "Column name must not be null.");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Column name must not be blank.");
        }
        Objects.requireNonNull(type, "Column type must not be null.");
        return new ColumnDefinition(name, type, null);
    }

    public static ColumnDefinition column(String name, String definition) {
        Objects.requireNonNull(name, "Column name must not be null.");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Column name must not be blank.");
        }
        Objects.requireNonNull(definition, "Column definition must not be null.");
        if (definition.isBlank()) {
            throw new IllegalArgumentException("Column definition must not be blank.");
        }
        return new ColumnDefinition(name, null, definition);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public ColumnType<?> type() {
        return this.type;
    }

    @Nullable
    public String definition() {
        return this.definition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.definition, that.definition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.definition);
    }
}

