/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.beans.PropertyVetoException;
import java.util.Arrays;

public class DefaultProfileTokenProvider
implements ProfileTokenProvider {
    private static final int UNINITIALIZED = -1;
    private AS400 system_;
    private int timeoutInterval_ = -1;
    private String userId_ = null;
    private int tokenType_ = -1;
    private Object extendedInfo_;
    private char[] additionalFactor_;
    private String verificationID_;
    private String remoteIPAddress_;

    public DefaultProfileTokenProvider() {
        this(new AS400());
    }

    public DefaultProfileTokenProvider(AS400 system) {
        this.setSystem(system);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setSystem(AS400 system) {
        this.system_ = system;
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval_;
    }

    public void setTimeoutInterval(int timeoutInterval) {
        this.timeoutInterval_ = timeoutInterval;
    }

    public int getTokenType() {
        return this.tokenType_;
    }

    public void setTokenType(int tokenType) {
        if (tokenType != 1 && tokenType != 3 && tokenType != 2) {
            throw new ExtendedIllegalArgumentException("tokenType", 2);
        }
        this.tokenType_ = tokenType;
    }

    public String getUserId() {
        return this.userId_;
    }

    public void setUserId(String userId) {
        if (null == userId || 0 == userId.length()) {
            throw new ExtendedIllegalArgumentException("userId", 1);
        }
        this.userId_ = userId;
    }

    public Object getExtendedInfo() {
        return this.extendedInfo_;
    }

    public void setPassword(String password) {
        char[] passwordCharArray = password == null ? null : password.toCharArray();
        try {
            this.setPassword(passwordCharArray);
        }
        finally {
            AS400Credential.clearArray(passwordCharArray);
        }
    }

    public void setPassword(char[] password) {
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length == 0) {
            throw new ExtendedIllegalArgumentException("password", 1);
        }
        this.setExtendedInfo(password);
    }

    public void setPasswordSpecialValue(int specialValue) {
        if (specialValue != 1 && specialValue != 2) {
            throw new ExtendedIllegalArgumentException("specialValue", 2);
        }
        this.setExtendedInfo(specialValue);
    }

    protected void setExtendedInfo(Object extendedInfo) {
        this.extendedInfo_ = extendedInfo;
    }

    public void setAdditionalAuthenticationFactor(char[] additionalAuthenticationFactor) throws PropertyVetoException {
        if (additionalAuthenticationFactor != null && additionalAuthenticationFactor.length > 64) {
            throw new ExtendedIllegalArgumentException("additionalAuthenticationFactor", 1);
        }
        this.additionalFactor_ = additionalAuthenticationFactor != null ? Arrays.copyOf(additionalAuthenticationFactor, additionalAuthenticationFactor.length) : null;
    }

    public char[] getAdditionalAuthenticationFactor() {
        return this.additionalFactor_ != null ? Arrays.copyOf(this.additionalFactor_, this.additionalFactor_.length) : null;
    }

    public void setVerificationID(String verificationID) throws PropertyVetoException {
        if (verificationID != null && verificationID.length() > 30) {
            throw new ExtendedIllegalArgumentException("verificationID", 1);
        }
        this.verificationID_ = verificationID;
    }

    public String getVerificationID() {
        return this.verificationID_ != null ? this.verificationID_ : "QIBM_OS400_JT400";
    }

    @Override
    public ProfileTokenCredential create() throws AS400SecurityException {
        this.checkFieldSet(this.system_, "system");
        this.checkFieldSet(this.timeoutInterval_, "timeoutInterval");
        this.checkFieldSet(this.userId_, "userId");
        this.checkFieldSet(this.tokenType_, "tokenType");
        this.checkFieldSet(this.extendedInfo_, "extendedInfo");
        try {
            ProfileTokenCredential newToken = new ProfileTokenCredential();
            newToken.setSystem(this.getSystem());
            newToken.setTimeoutInterval(this.getTimeoutInterval());
            newToken.setTokenType(this.getTokenType());
            newToken.setVerificationID(this.verificationID_);
            newToken.setRemoteIPAddress(this.remoteIPAddress_);
            Object extended = this.getExtendedInfo();
            if (extended instanceof Integer) {
                newToken.setToken(this.getUserId(), (int)((Integer)extended));
            } else if (extended instanceof String) {
                char[] password = ((String)extended).toCharArray();
                newToken.setTokenExtended(this.getUserId(), password, this.additionalFactor_);
                Arrays.fill(password, ' ');
            } else if (extended instanceof char[]) {
                newToken.setTokenExtended(this.getUserId(), (char[])extended, this.additionalFactor_);
            } else {
                throw new ExtendedIllegalStateException("extendedInfo", 6);
            }
            return newToken;
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)pve);
            throw new InternalErrorException(10);
        }
    }

    protected final void checkFieldSet(Object field, String fieldName) {
        if (null == field) {
            throw new ExtendedIllegalStateException(fieldName, 4);
        }
    }

    protected final void checkFieldSet(int field, String description) {
        if (field < 0) {
            throw new ExtendedIllegalStateException(description, 4);
        }
    }
}

